/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerCosArmor
extends RecipeBookMenu<CraftingContainer> {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Player player;
    private final CraftingContainer craftingInventory = new CraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResultInventory = new ResultContainer();

    public ContainerCosArmor(Inventory invPlayer, InventoryCosArmor invCosArmor, final Player player, int windowId) {
        super(ModObjects.getTypeContainerCosArmor(), windowId);
        int i;
        this.player = player;
        this.m_38897_((Slot)new ResultSlot(player, this.craftingInventory, (Container)this.craftResultInventory, 0, 154, 28));
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m_38897_(new Slot((Container)this.craftingInventory, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)invPlayer, 39 - k, 8, 8 + k * 18){

                public boolean m_8010_(Player playerIn) {
                    ItemStack itemstack = this.m_7993_();
                    return (itemstack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(playerIn);
                }

                @Nullable
                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)player);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)invPlayer, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)invPlayer, i1, 8 + i1 * 18, 142));
        }
        this.m_38897_(new Slot((Container)invPlayer, 40, 77, 62){

            @Nullable
            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[i];
            this.m_38897_(new Slot(invCosArmor, 3 - i, 98 + i * 18, 62){

                @Nullable
                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)player);
                }
            });
        }
    }

    private static void updateCrafting(AbstractContainerMenu menu, Level world, Player player, CraftingContainer craftingInventory, ResultContainer craftResultInventory) {
        if (!world.f_46443_) {
            CraftingRecipe recipe;
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack stack = ItemStack.f_41583_;
            Optional optionalrecipe = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, world);
            if (optionalrecipe.isPresent() && craftResultInventory.m_40135_(world, serverplayer, (Recipe)(recipe = (CraftingRecipe)optionalrecipe.get()))) {
                stack = recipe.m_5874_((Container)craftingInventory);
            }
            craftResultInventory.m_6836_(0, stack);
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 0, stack));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResultInventory && super.m_5882_(stack, slotIn);
    }

    public void m_6650_() {
        this.craftResultInventory.m_6211_();
        this.craftingInventory.m_6211_();
    }

    public void m_5816_(StackedContents arg0) {
        this.craftingInventory.m_5809_(arg0);
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int slotIndex) {
        return slotIndex != this.m_6636_();
    }

    public int m_6656_() {
        return this.craftingInventory.m_39346_();
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6653_() {
        return 5;
    }

    public int m_6635_() {
        return this.craftingInventory.m_39347_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> arg0) {
        return arg0.m_5818_((Container)this.craftingInventory, this.player.f_19853_);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.craftResultInventory.m_6211_();
        if (!playerIn.f_19853_.f_46443_) {
            this.m_150411_(playerIn, (Container)this.craftingInventory);
        }
    }

    public void m_6199_(Container inventoryIn) {
        ContainerCosArmor.updateCrafting((AbstractContainerMenu)this, this.player.f_19853_, this.player, this.craftingInventory, this.craftResultInventory);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            int j;
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            EquipmentSlot desiredSlot = Mob.m_147233_((ItemStack)stack);
            if (slotIndex == 0) {
                if (!this.m_38903_(stack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack1, stack);
            } else if (slotIndex >= 1 && slotIndex < 5 ? !this.m_38903_(stack1, 9, 45, false) : (slotIndex >= 5 && slotIndex < 9 ? !this.m_38903_(stack1, 9, 45, false) : (slotIndex >= 46 && slotIndex < 50 ? !this.m_38903_(stack1, 9, 45, false) : (desiredSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(8 - desiredSlot.m_20749_())).m_6657_() ? !this.m_38903_(stack1, j = 8 - desiredSlot.m_20749_(), j + 1, false) : (desiredSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(49 - desiredSlot.m_20749_())).m_6657_() ? !this.m_38903_(stack1, j = 49 - desiredSlot.m_20749_(), j + 1, false) : (slotIndex >= 9 && slotIndex < 36 ? !this.m_38903_(stack1, 36, 45, false) : (slotIndex >= 36 && slotIndex < 45 ? !this.m_38903_(stack1, 9, 36, false) : !this.m_38903_(stack1, 9, 45, false)))))))) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack1);
            if (slotIndex == 0) {
                player.m_36176_(stack1, false);
            }
        }
        return stack;
    }
}

