/*
 * Decompiled with CFR 0.152.
 */
package me.dinnerbeef.compressium;

import com.google.gson.annotations.JsonAdapter;
import java.util.Objects;
import me.dinnerbeef.compressium.CompressibleType;
import net.minecraft.resources.ResourceLocation;

public final class CompressibleBlock {
    private final String name;
    private final int nestedDepth;
    private final boolean isBlockOf;
    @JsonAdapter(value=ResourceLocation.Serializer.class)
    private final ResourceLocation baseResourceLocation;
    @JsonAdapter(value=ResourceLocation.Serializer.class)
    private final ResourceLocation particlePath;
    @JsonAdapter(value=ResourceLocation.Serializer.class)
    private final ResourceLocation baseBlockModel;
    @JsonAdapter(value=CompressibleType.Serializer.class)
    private final CompressibleType type;

    public CompressibleBlock(String name, ResourceLocation baseResourceLocation, ResourceLocation particlePath, ResourceLocation baseBlockModel, CompressibleType type, int nestedDepth, boolean isBlockOf) {
        this.name = name;
        this.baseResourceLocation = baseResourceLocation;
        this.particlePath = particlePath;
        this.baseBlockModel = baseBlockModel;
        this.type = type;
        this.nestedDepth = nestedDepth;
        this.isBlockOf = isBlockOf;
    }

    public String name() {
        return this.name;
    }

    public ResourceLocation baseResourceLocation() {
        return this.baseResourceLocation;
    }

    public ResourceLocation particlePath() {
        return this.particlePath;
    }

    public ResourceLocation baseBlockModel() {
        return this.baseBlockModel;
    }

    public CompressibleType type() {
        return this.type;
    }

    public int getNestedDepth() {
        if (this.nestedDepth == 0) {
            return 9;
        }
        return this.nestedDepth;
    }

    public boolean isBlockOf() {
        return this.isBlockOf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressibleBlock block = (CompressibleBlock)o;
        return this.nestedDepth == block.nestedDepth && this.isBlockOf == block.isBlockOf && Objects.equals(this.name, block.name) && Objects.equals(this.baseResourceLocation, block.baseResourceLocation) && Objects.equals(this.particlePath, block.particlePath) && Objects.equals(this.baseBlockModel, block.baseBlockModel) && this.type == block.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.nestedDepth, this.isBlockOf, this.baseResourceLocation, this.particlePath, this.baseBlockModel, this.type});
    }

    public String toString() {
        return "CompressableBlock{name='" + this.name + "', nestedDepth=" + this.nestedDepth + ", isBlockOf=" + this.isBlockOf + ", baseResourceLocation=" + this.baseResourceLocation + ", particlePath=" + this.particlePath + ", baseBlockModel=" + this.baseBlockModel + ", type=" + this.type + "}";
    }
}

