/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.gui;

import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.block_entities.PrecisionDispellerEntity;
import com.cyanogen.experienceobelisk.registries.RegisterMenus;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PrecisionDispellerMenu
extends AbstractContainerMenu {
    SimpleContainer container = new SimpleContainer(2);
    Player player;
    BlockPos posServer;
    ExperienceObeliskEntity obeliskClient;
    PrecisionDispellerEntity dispellerServer;

    public PrecisionDispellerMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        this(id, inventory, inventory.f_35978_, new BlockPos(0, 0, 0));
        Level level = inventory.f_35978_.f_19853_;
        BlockEntity entity = level.m_7702_(data.m_130135_());
        if (entity instanceof PrecisionDispellerEntity) {
            BlockPos obeliskPos;
            BlockEntity blockEntity;
            PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)entity;
            if (dispeller.isBound && (blockEntity = level.m_7702_(obeliskPos = dispeller.getBoundPos())) instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk;
                this.obeliskClient = obelisk = (ExperienceObeliskEntity)blockEntity;
            }
        }
    }

    public PrecisionDispellerMenu(int id, Inventory inventory, Player player, final BlockPos pos) {
        super((MenuType)RegisterMenus.PRECISION_DISPELLER_MENU.get(), id);
        this.player = player;
        this.posServer = pos;
        this.dispellerServer = (PrecisionDispellerEntity)player.f_19853_.m_7702_(pos);
        this.m_38897_(new Slot((Container)this.container, 0, 17, 18){

            public void m_142406_(Player player, ItemStack stack) {
                this.f_40218_.m_6836_(1, ItemStack.f_41583_);
                super.m_142406_(player, stack);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot((Container)this.container, 1, 17, 52){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                Level level = player.f_19853_;
                PrecisionDispellerMenu.this.handleExperience(this.f_40218_.m_8020_(0), stack, level, player);
                PrecisionDispellerMenu.this.handleAnimation(level, pos);
                player.m_5496_(SoundEvents.f_11998_, 1.0f, 1.0f);
                this.f_40218_.m_6836_(0, ItemStack.f_41583_);
                super.m_142406_(player, stack);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void handleExperience(ItemStack inputItem, ItemStack outputItem, Level level, Player player) {
        player.m_5496_(SoundEvents.f_11998_, 0.7f, 1.0f);
        if (!level.f_46443_) {
            ServerLevel server = (ServerLevel)level;
            Enchantment removed = null;
            int enchLevel = 0;
            Map map = EnchantmentHelper.m_44831_((ItemStack)inputItem);
            Map map2 = EnchantmentHelper.m_44831_((ItemStack)outputItem);
            for (Map.Entry entry : map.entrySet()) {
                if (map2.containsKey(entry.getKey())) continue;
                removed = (Enchantment)entry.getKey();
                enchLevel = (Integer)entry.getValue();
                break;
            }
            if (removed != null) {
                BlockEntity blockEntity;
                if (this.dispellerServer.isBound && (blockEntity = server.m_7702_(this.dispellerServer.getBoundPos())) instanceof ExperienceObeliskEntity) {
                    ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
                    this.handleExperienceBound(removed, enchLevel, server, obelisk);
                } else {
                    this.handleExperienceUnbound(removed, enchLevel, server);
                }
            }
        }
    }

    public void handleExperienceBound(Enchantment removed, int enchLevel, ServerLevel server, ExperienceObeliskEntity obelisk) {
        if (removed.m_6589_()) {
            if (obelisk.getFluidAmount() >= 27900) {
                obelisk.drain(27900);
            } else {
                int remainder = 1395 - obelisk.getFluidAmount() / 20;
                obelisk.setFluid(0);
                this.player.m_6756_(-remainder);
            }
        } else {
            int points = removed.m_6183_(enchLevel);
            if (obelisk.getSpace() / 20 < points) {
                int remainder = points - obelisk.getSpace() / 20;
                obelisk.setFluid(ExperienceObeliskEntity.capacity);
                ExperienceOrb orb = new ExperienceOrb((Level)server, (double)this.posServer.m_123341_() + 0.5, (double)this.posServer.m_123342_() + 0.5, (double)this.posServer.m_123343_() + 0.5, remainder);
                server.m_7967_((Entity)orb);
            } else {
                obelisk.fill(points * 20);
            }
        }
    }

    public void handleExperienceUnbound(Enchantment removed, int enchLevel, ServerLevel server) {
        if (removed.m_6589_()) {
            this.player.m_6756_(-1395);
        } else {
            int points = removed.m_6183_(enchLevel);
            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)this.posServer.m_123341_() + 0.5, (double)this.posServer.m_123342_() + 0.5, (double)this.posServer.m_123343_() + 0.5, points);
            server.m_7967_((Entity)orb);
        }
    }

    public void handleAnimation(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrecisionDispellerEntity) {
            PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)blockEntity;
            dispeller.pendingAnimation = true;
            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
        }
    }

    public void m_6877_(Player player) {
        ItemStack item = this.container.m_8020_(0);
        if (!player.m_36356_(item)) {
            player.m_36176_(item, false);
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return player.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.posServer)) < 7.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            if (index == 0) {
                this.container.m_6836_(1, ItemStack.f_41583_);
            } else if (index == 1) {
                this.handleExperience(((Slot)this.f_38839_.get(0)).m_7993_(), ((Slot)this.f_38839_.get(1)).m_7993_(), player.f_19853_, player);
                this.container.m_6836_(0, ItemStack.f_41583_);
                this.handleAnimation(this.player.f_19853_, this.posServer);
            }
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 2 ? !this.m_38903_(itemstack1, 2, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

