/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelRegistryHelper {
    private final List<Pair<ModelResourceLocation, BakedModel>> registerModels = new LinkedList<Pair<ModelResourceLocation, BakedModel>>();
    private final List<IModelBakeCallbackPre> modelBakePreCallbacks = new LinkedList<IModelBakeCallbackPre>();
    private final List<IModelBakeCallback> modelBakeCallbacks = new LinkedList<IModelBakeCallback>();

    public ModelRegistryHelper(IEventBus eventBus) {
        eventBus.register((Object)this);
    }

    public ModelRegistryHelper() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    public void registerPreBakeCallback(IModelBakeCallbackPre callback) {
        this.modelBakePreCallbacks.add(callback);
    }

    public void registerCallback(IModelBakeCallback callback) {
        this.modelBakeCallbacks.add(callback);
    }

    public void register(ModelResourceLocation location, BakedModel model) {
        this.registerModels.add((Pair<ModelResourceLocation, BakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    @SubscribeEvent
    public void onModelBake(ModelEvent.BakingCompleted event) {
        for (IModelBakeCallbackPre iModelBakeCallbackPre : this.modelBakePreCallbacks) {
            iModelBakeCallbackPre.onModelBakePre(event);
        }
        for (Pair pair : this.registerModels) {
            event.getModels().put((ResourceLocation)pair.getKey(), (BakedModel)pair.getValue());
        }
        for (IModelBakeCallback iModelBakeCallback : this.modelBakeCallbacks) {
            iModelBakeCallback.onModelBake(event);
        }
    }

    public static interface IModelBakeCallbackPre {
        public void onModelBakePre(ModelEvent.BakingCompleted var1);
    }

    public static interface IModelBakeCallback {
        public void onModelBake(ModelEvent.BakingCompleted var1);
    }
}

