/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BlueprintChangeRecipe
extends CustomRecipe {
    public BlueprintChangeRecipe(ResourceLocation id) {
        super(id);
    }

    public ItemStack m_8043_() {
        ItemStack bp = new ItemStack((ItemLike)CapsuleItems.CAPSULE.get(), 1);
        CapsuleItem.setState(bp, CapsuleItem.CapsuleState.DEPLOYED);
        CapsuleItem.setBlueprint(bp);
        CapsuleItem.setBaseColor(bp, 3949738);
        CapsuleItem.setStructureName(bp, "config/capsule/rewards/example");
        return bp;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CapsuleRecipes.BLUEPRINT_CHANGE_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack blueprintCapsule = null;
        ItemStack templateCapsule = null;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                blueprintCapsule = itemstack;
                continue;
            }
            if (!CapsuleItem.hasStructureLink(itemstack)) continue;
            templateCapsule = itemstack;
            nonnulllist.set(i, (Object)templateCapsule.m_41777_());
        }
        return nonnulllist;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int sourceCapsule = 0;
        int blueprint = 0;
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (blueprint == 0 && CapsuleItem.isBlueprint(itemstack)) {
                ++blueprint;
                continue;
            }
            if (CapsuleItem.hasStructureLink(itemstack) && (CapsuleItem.CapsuleState.DEPLOYED != CapsuleItem.getState(itemstack) || CapsuleItem.isBlueprint(itemstack))) {
                ++sourceCapsule;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return sourceCapsule == 1 && blueprint == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        String templateStructure = null;
        Integer templateSize = null;
        ItemStack blueprintCapsule = null;
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                blueprintCapsule = itemstack.m_41777_();
                continue;
            }
            if (!CapsuleItem.hasStructureLink(itemstack)) continue;
            templateStructure = CapsuleItem.getStructureName(itemstack);
            templateSize = CapsuleItem.getSize(itemstack);
        }
        if (templateStructure != null && blueprintCapsule != null) {
            if (blueprintCapsule.m_41783_() != null) {
                blueprintCapsule.m_41783_().m_128359_("prevStructureName", CapsuleItem.getStructureName(blueprintCapsule));
                blueprintCapsule.m_41783_().m_128379_("templateShouldBeCopied", true);
            }
            CapsuleItem.setStructureName(blueprintCapsule, templateStructure);
            CapsuleItem.setState(blueprintCapsule, CapsuleItem.CapsuleState.DEPLOYED);
            CapsuleItem.setSize(blueprintCapsule, templateSize);
            CapsuleItem.cleanDeploymentTags(blueprintCapsule);
            return blueprintCapsule;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

