/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.client.CapsulePreviewHandler;
import capsule.client.render.CapsuleTemplateRenderer;
import capsule.structure.CapsuleTemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleFullContentAnswerToClient {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleFullContentAnswerToClient.class);
    public static final long BUFFER_MAX_SIZE = 1000000L;
    private CapsuleTemplate template;
    private String structureName;

    public CapsuleFullContentAnswerToClient(CapsuleTemplate template, String structureName) {
        this.template = null;
        this.structureName = null;
        this.template = template;
        this.structureName = structureName;
    }

    public void onClient(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.template != null) {
                Map<String, CapsuleTemplate> map = CapsulePreviewHandler.currentFullPreview;
                synchronized (map) {
                    CapsulePreviewHandler.currentFullPreview.put(this.getStructureName(), this.template);
                    if (CapsulePreviewHandler.cachedFullPreview.containsKey(this.getStructureName())) {
                        CapsulePreviewHandler.cachedFullPreview.get(this.getStructureName()).setWorldDirty();
                    } else {
                        CapsulePreviewHandler.cachedFullPreview.put(this.getStructureName(), new CapsuleTemplateRenderer());
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleFullContentAnswerToClient(FriendlyByteBuf buf) {
        block5: {
            this.template = null;
            this.structureName = null;
            try {
                this.structureName = buf.m_130136_(Short.MAX_VALUE);
                boolean isSmallEnough = buf.readBoolean();
                this.template = null;
                if (!isSmallEnough) break block5;
                ByteArrayInputStream bytearrayoutputstream = new ByteArrayInputStream(buf.m_130052_());
                CompoundTag nbt = null;
                try {
                    nbt = NbtIo.m_128939_((InputStream)bytearrayoutputstream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (nbt != null) {
                    this.template = new CapsuleTemplate();
                    this.template.load(nbt, "`networked from server`");
                }
            }
            catch (IndexOutOfBoundsException ioe) {
                LOGGER.error("Exception while reading CapsuleFullContentAnswerToClient: " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.structureName);
        CompoundTag nbt = StructureSaver.getTemplateNBTData(this.template);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try {
            NbtIo.m_128947_((CompoundTag)nbt, (OutputStream)bytearrayoutputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if ((long)bytearrayoutputstream.size() < 1000000L) {
                buf.writeBoolean(true);
                buf.m_130087_(bytearrayoutputstream.toByteArray());
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    public String getStructureName() {
        return this.structureName;
    }

    public CapsuleTemplate getTemplate() {
        return this.template;
    }
}

