/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleFullContentAnswerToClient;
import capsule.network.CapsuleNetwork;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewQueryToServer.class);
    private String structureName = null;

    public CapsuleContentPreviewQueryToServer(String structureName) {
        this.setStructureName(structureName);
    }

    public CapsuleContentPreviewQueryToServer(FriendlyByteBuf buf) {
        try {
            this.setStructureName(buf.m_130136_(Short.MAX_VALUE));
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading AskCapsuleContentPreviewMessageToServer: " + ioe);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (buf == null) {
            return;
        }
        String name = this.getStructureName();
        if (name == null) {
            name = "";
        }
        buf.m_130070_(name);
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when AskCapsuleContentPreviewMessageToServer was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack heldItem = sendingPlayer.m_21205_();
            if (!(heldItem.m_41720_() instanceof CapsuleItem) || CapsuleItem.getStructureName(heldItem) == null) {
                return;
            }
            ServerLevel serverworld = sendingPlayer.m_9236_();
            Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, serverworld);
            CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
            if (template != null) {
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> this.lambda$onServer$0(template, (Supplier)ctx));
                CapsuleNetwork.wrapper.reply((Object)new CapsuleFullContentAnswerToClient(template, this.getStructureName()), (NetworkEvent.Context)ctx.get());
            } else if (heldItem.m_41782_()) {
                String structureName = heldItem.m_41783_().m_128461_("structureName");
                sendingPlayer.m_213846_((Component)Component.m_237110_((String)"capsule.error.templateNotFound", (Object[])new Object[]{structureName}));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return this.getClass().toString();
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    private /* synthetic */ void lambda$onServer$0(CapsuleTemplate template, Supplier ctx) {
        List<AABB> blockspos = Spacial.mergeVoxels(template.getPalette());
        CapsuleNetwork.wrapper.reply((Object)new CapsuleContentPreviewAnswerToClient(blockspos, this.getStructureName()), (NetworkEvent.Context)ctx.get());
    }
}

