/*
 * Decompiled with CFR 0.152.
 */
package capsule.client.render.vbo;

import capsule.client.render.vbo.CustomBufferBuilder;
import capsule.client.render.vbo.CustomVertexBuffer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class MultiVBORenderer
implements Closeable {
    private static final int BUFFER_SIZE = 0x600000;
    private final ImmutableMap<RenderType, CustomVertexBuffer> buffers;
    private final ImmutableMap<RenderType, CustomBufferBuilder.State> sortCaches;

    public static MultiVBORenderer of(Consumer<MultiBufferSource> vertexProducer) {
        HashMap builders = Maps.newHashMap();
        vertexProducer.accept(rt -> (VertexConsumer)builders.computeIfAbsent(rt, _rt -> {
            CustomBufferBuilder builder = new CustomBufferBuilder(0x600000);
            builder.begin(_rt.m_173186_().f_166946_, _rt.m_110508_());
            return builder;
        }));
        HashMap sortCaches = Maps.newHashMap();
        Map buffers = Maps.transformEntries((Map)builders, (rt, builder) -> {
            Objects.requireNonNull(rt);
            Objects.requireNonNull(builder);
            sortCaches.put(rt, builder.getVertexState());
            builder.finishDrawing();
            VertexFormat fmt = rt.m_110508_();
            CustomVertexBuffer vbo = new CustomVertexBuffer(fmt);
            vbo.upload((CustomBufferBuilder)((Object)builder));
            return vbo;
        });
        return new MultiVBORenderer(buffers, sortCaches);
    }

    protected MultiVBORenderer(Map<RenderType, CustomVertexBuffer> buffers, Map<RenderType, CustomBufferBuilder.State> sortCaches) {
        this.buffers = ImmutableMap.copyOf(buffers);
        this.sortCaches = ImmutableMap.copyOf(sortCaches);
    }

    public void sort(float x, float y, float z) {
        for (Map.Entry kv : this.sortCaches.entrySet()) {
            RenderType rt = (RenderType)kv.getKey();
            CustomBufferBuilder.State state = (CustomBufferBuilder.State)kv.getValue();
            CustomBufferBuilder builder = new CustomBufferBuilder(0x600000);
            builder.begin(rt.m_173186_().f_166946_, rt.m_110508_());
            builder.setVertexState(state);
            builder.sortVertexData(x, y, z);
            builder.finishDrawing();
            CustomVertexBuffer vbo = (CustomVertexBuffer)this.buffers.get((Object)rt);
            vbo.upload(builder);
        }
    }

    public void render(Matrix4f matrix) {
        this.buffers.forEach((rt, vbo) -> {
            VertexFormat fmt = rt.m_110508_();
            rt.m_110185_();
            vbo.bindBuffer();
            fmt.m_166912_();
            vbo.draw(matrix, rt.m_173186_().f_166946_);
            CustomVertexBuffer.unbindBuffer();
            fmt.m_86024_();
            rt.m_110188_();
        });
    }

    @Override
    public void close() {
        this.buffers.values().forEach(CustomVertexBuffer::close);
    }
}

