/*
 * Decompiled with CFR 0.152.
 */
package capsule.client.render.vbo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomBufferBuilder
extends DefaultedVertexConsumer
implements BufferVertexConsumer {
    private static final Logger LOGGER = LogManager.getLogger();
    private ByteBuffer byteBuffer;
    private final List<DrawState> drawStates = Lists.newArrayList();
    private int drawStateIndex = 0;
    private int renderedBytes = 0;
    private int nextElementBytes = 0;
    private int uploadedBytes = 0;
    private int vertexCount;
    @Nullable
    private VertexFormatElement vertexFormatElement;
    private int vertexFormatIndex;
    private int drawMode;
    private VertexFormat vertexFormat;
    private boolean fastFormat;
    private boolean fullFormat;
    private boolean isDrawing;

    public CustomBufferBuilder(int bufferSizeIn) {
        this.byteBuffer = MemoryTracker.m_182527_((int)(bufferSizeIn * 4));
    }

    protected void growBuffer() {
        this.growBuffer(this.vertexFormat.m_86020_());
    }

    private void growBuffer(int increaseAmount) {
        if (this.nextElementBytes + increaseAmount > this.byteBuffer.capacity()) {
            int i = this.byteBuffer.capacity();
            int j = i + CustomBufferBuilder.roundUpPositive(increaseAmount);
            LOGGER.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
            ByteBuffer bytebuffer = MemoryTracker.m_182527_((int)j);
            this.byteBuffer.position(0);
            bytebuffer.put(this.byteBuffer);
            bytebuffer.rewind();
            this.byteBuffer = bytebuffer;
        }
    }

    private static int roundUpPositive(int xIn) {
        int j;
        int i = 0x200000;
        if (xIn == 0) {
            return i;
        }
        if (xIn < 0) {
            i *= -1;
        }
        return (j = xIn % i) == 0 ? xIn : xIn + i - j;
    }

    public void sortVertexData(float cameraX, float cameraY, float cameraZ) {
        this.byteBuffer.clear();
        FloatBuffer floatbuffer = this.byteBuffer.asFloatBuffer();
        int i = this.vertexCount / 4;
        float[] afloat = new float[i];
        for (int j = 0; j < i; ++j) {
            afloat[j] = CustomBufferBuilder.getDistanceSq(floatbuffer, cameraX, cameraY, cameraZ, this.vertexFormat.m_86017_(), this.renderedBytes / 4 + j * this.vertexFormat.m_86020_());
        }
        int[] aint = new int[i];
        int k = 0;
        while (k < aint.length) {
            aint[k] = k++;
        }
        IntArrays.mergeSort((int[])aint, (p_227830_1_, p_227830_2_) -> Floats.compare((float)afloat[p_227830_1_], (float)afloat[p_227830_2_]));
        BitSet bitset = new BitSet();
        FloatBuffer floatbuffer1 = FloatBuffer.allocate(this.vertexFormat.m_86017_() * 6);
        int l = bitset.nextClearBit(0);
        while (l < aint.length) {
            int i1 = aint[l];
            if (i1 != l) {
                this.limitToVertex(floatbuffer, i1);
                floatbuffer1.clear();
                floatbuffer1.put(floatbuffer);
                int j1 = i1;
                int k1 = aint[i1];
                while (j1 != l) {
                    this.limitToVertex(floatbuffer, k1);
                    FloatBuffer floatbuffer2 = floatbuffer.slice();
                    this.limitToVertex(floatbuffer, j1);
                    floatbuffer.put(floatbuffer2);
                    bitset.set(j1);
                    j1 = k1;
                    k1 = aint[k1];
                }
                this.limitToVertex(floatbuffer, l);
                floatbuffer1.flip();
                floatbuffer.put(floatbuffer1);
            }
            bitset.set(l);
            l = bitset.nextClearBit(l + 1);
        }
    }

    private void limitToVertex(FloatBuffer floatBufferIn, int indexIn) {
        int i = this.vertexFormat.m_86017_() * 4;
        floatBufferIn.limit(this.renderedBytes / 4 + (indexIn + 1) * i);
        floatBufferIn.position(this.renderedBytes / 4 + indexIn * i);
    }

    public State getVertexState() {
        this.byteBuffer.limit(this.nextElementBytes);
        this.byteBuffer.position(this.renderedBytes);
        ByteBuffer bytebuffer = ByteBuffer.allocate(this.vertexCount * this.vertexFormat.m_86020_());
        bytebuffer.put(this.byteBuffer);
        this.byteBuffer.clear();
        return new State(bytebuffer, this.vertexFormat);
    }

    private static float getDistanceSq(FloatBuffer floatBufferIn, float x, float y, float z, int integerSize, int offset) {
        float f = floatBufferIn.get(offset + integerSize * 0 + 0);
        float f1 = floatBufferIn.get(offset + integerSize * 0 + 1);
        float f2 = floatBufferIn.get(offset + integerSize * 0 + 2);
        float f3 = floatBufferIn.get(offset + integerSize * 1 + 0);
        float f4 = floatBufferIn.get(offset + integerSize * 1 + 1);
        float f5 = floatBufferIn.get(offset + integerSize * 1 + 2);
        float f6 = floatBufferIn.get(offset + integerSize * 2 + 0);
        float f7 = floatBufferIn.get(offset + integerSize * 2 + 1);
        float f8 = floatBufferIn.get(offset + integerSize * 2 + 2);
        float f9 = floatBufferIn.get(offset + integerSize * 3 + 0);
        float f10 = floatBufferIn.get(offset + integerSize * 3 + 1);
        float f11 = floatBufferIn.get(offset + integerSize * 3 + 2);
        float f12 = (f + f3 + f6 + f9) * 0.25f - x;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y;
        float f14 = (f2 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public void setVertexState(State state) {
        state.stateByteBuffer.clear();
        int i = state.stateByteBuffer.capacity();
        this.growBuffer(i);
        this.byteBuffer.limit(this.byteBuffer.capacity());
        this.byteBuffer.position(this.renderedBytes);
        this.byteBuffer.put(state.stateByteBuffer);
        this.byteBuffer.clear();
        VertexFormat vertexformat = state.stateVertexFormat;
        this.setVertexFormat(vertexformat);
        this.vertexCount = i / vertexformat.m_86020_();
        this.nextElementBytes = this.renderedBytes + this.vertexCount * vertexformat.m_86020_();
    }

    public void begin(int glMode, VertexFormat format) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already building!");
        }
        this.isDrawing = true;
        this.drawMode = glMode;
        this.setVertexFormat(format);
        this.vertexFormatElement = (VertexFormatElement)format.m_86023_().get(0);
        this.vertexFormatIndex = 0;
        this.byteBuffer.clear();
    }

    private void setVertexFormat(VertexFormat vertexFormatIn) {
        if (this.vertexFormat != vertexFormatIn) {
            this.vertexFormat = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormat.f_85820_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormat.f_85811_;
            this.fastFormat = flag || flag1;
            this.fullFormat = flag;
        }
    }

    public void finishDrawing() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not building!");
        }
        this.isDrawing = false;
        this.drawStates.add(new DrawState(this.vertexFormat, this.vertexCount, this.drawMode));
        this.renderedBytes += this.vertexCount * this.vertexFormat.m_86020_();
        this.vertexCount = 0;
        this.vertexFormatElement = null;
        this.vertexFormatIndex = 0;
    }

    public void m_5672_(int indexIn, byte byteIn) {
        this.byteBuffer.put(this.nextElementBytes + indexIn, byteIn);
    }

    public void m_5586_(int indexIn, short shortIn) {
        this.byteBuffer.putShort(this.nextElementBytes + indexIn, shortIn);
    }

    public void m_5832_(int indexIn, float floatIn) {
        this.byteBuffer.putFloat(this.nextElementBytes + indexIn, floatIn);
    }

    public void m_5752_() {
        if (this.vertexFormatIndex != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.vertexCount;
        this.growBuffer();
    }

    public void m_5751_() {
        VertexFormatElement vertexformatelement;
        ImmutableList immutablelist = this.vertexFormat.m_86023_();
        this.vertexFormatIndex = (this.vertexFormatIndex + 1) % immutablelist.size();
        this.nextElementBytes += this.vertexFormatElement.m_86050_();
        this.vertexFormatElement = vertexformatelement = (VertexFormatElement)immutablelist.get(this.vertexFormatIndex);
        if (vertexformatelement.m_86048_() == VertexFormatElement.Usage.PADDING) {
            this.m_5751_();
        }
        if (this.f_85824_ && this.vertexFormatElement.m_86048_() == VertexFormatElement.Usage.COLOR) {
            super.m_6122_(this.f_85825_, this.f_85826_, this.f_85827_, this.f_85828_);
        }
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        return super.m_6122_(red, green, blue, alpha);
    }

    public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        if (this.fastFormat) {
            int i;
            this.m_5832_(0, x);
            this.m_5832_(4, y);
            this.m_5832_(8, z);
            this.m_5672_(12, (byte)(red * 255.0f));
            this.m_5672_(13, (byte)(green * 255.0f));
            this.m_5672_(14, (byte)(blue * 255.0f));
            this.m_5672_(15, (byte)(alpha * 255.0f));
            this.m_5832_(16, texU);
            this.m_5832_(20, texV);
            if (this.fullFormat) {
                this.m_5586_(24, (short)(overlayUV & 0xFFFF));
                this.m_5586_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i = 28;
            } else {
                i = 24;
            }
            this.m_5586_(i + 0, (short)(lightmapUV & 0xFFFF));
            this.m_5586_(i + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.m_5672_(i + 4, BufferVertexConsumer.m_85774_((float)normalX));
            this.m_5672_(i + 5, BufferVertexConsumer.m_85774_((float)normalY));
            this.m_5672_(i + 6, BufferVertexConsumer.m_85774_((float)normalZ));
            this.nextElementBytes += i + 8;
            this.m_5752_();
        } else {
            super.m_5954_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> getNextBuffer() {
        DrawState bufferbuilder$drawstate = this.drawStates.get(this.drawStateIndex++);
        this.byteBuffer.position(this.uploadedBytes);
        this.uploadedBytes += bufferbuilder$drawstate.getVertexCount() * bufferbuilder$drawstate.getFormat().m_86020_();
        this.byteBuffer.limit(this.uploadedBytes);
        if (this.drawStateIndex == this.drawStates.size() && this.vertexCount == 0) {
            this.reset();
        }
        ByteBuffer bytebuffer = this.byteBuffer.slice();
        this.byteBuffer.clear();
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void reset() {
        if (this.renderedBytes != this.uploadedBytes) {
            LOGGER.warn("Bytes mismatch " + this.renderedBytes + " " + this.uploadedBytes);
        }
        this.discard();
    }

    public void discard() {
        this.renderedBytes = 0;
        this.uploadedBytes = 0;
        this.nextElementBytes = 0;
        this.drawStates.clear();
        this.drawStateIndex = 0;
    }

    public VertexFormatElement m_6297_() {
        if (this.vertexFormatElement == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.vertexFormatElement;
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }

    public void putBulkData(ByteBuffer buffer) {
        this.growBuffer(buffer.limit() + this.vertexFormat.m_86020_());
        this.byteBuffer.position(this.vertexCount * this.vertexFormat.m_86020_());
        this.byteBuffer.put(buffer);
        this.vertexCount += buffer.limit() / this.vertexFormat.m_86020_();
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class State {
        private final ByteBuffer stateByteBuffer;
        private final VertexFormat stateVertexFormat;

        private State(ByteBuffer byteBufferIn, VertexFormat vertexFormatIn) {
            this.stateByteBuffer = byteBufferIn;
            this.stateVertexFormat = vertexFormatIn;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DrawState {
        private final VertexFormat format;
        private final int vertexCount;
        private final int drawMode;

        private DrawState(VertexFormat formatIn, int vertexCountIn, int drawModeIn) {
            this.format = formatIn;
            this.vertexCount = vertexCountIn;
            this.drawMode = drawModeIn;
        }

        public VertexFormat getFormat() {
            return this.format;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getDrawMode() {
            return this.drawMode;
        }
    }
}

