/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block;

import com.ultramega.botanypotstiers.Constants;
import com.ultramega.botanypotstiers.PotTiers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TieredBotanyPotVariantGenerator {
    public static File blockDir = TieredBotanyPotVariantGenerator.makeDir("assets/botanypotstiers/models/block");
    public static File itemDir = TieredBotanyPotVariantGenerator.makeDir("assets/botanypotstiers/models/item");
    public static File stateDir = TieredBotanyPotVariantGenerator.makeDir("assets/botanypotstiers/blockstates");
    public static File lootDir = TieredBotanyPotVariantGenerator.makeDir("data/botanypotstiers/loot_tables/blocks");
    public static File craftingDir = TieredBotanyPotVariantGenerator.makeDir("data/botanypotstiers/recipes/crafting");

    public static void generate() {
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50352_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50287_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50288_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50289_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50290_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50291_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50292_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50293_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50294_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50295_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50296_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50297_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50298_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50299_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50300_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50301_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50302_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50526_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50527_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50528_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50529_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50530_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50531_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50532_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50533_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50534_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50535_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50536_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50537_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50538_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50539_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50540_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50541_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50542_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50543_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50544_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50545_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50494_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50495_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50496_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50497_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50498_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50499_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50500_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50501_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50502_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50503_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50504_);
        TieredBotanyPotVariantGenerator.generatePot(Blocks.f_50505_);
    }

    public static void generatePot(Block block) {
        try {
            ResourceLocation blockId = Registry.f_122824_.m_7981_((Object)block);
            for (PotTiers tier : PotTiers.values()) {
                Constants.LOG.info("botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_botany_pot");
                Constants.LOG.info("botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot");
                TieredBotanyPotVariantGenerator.generateBlockState(tier, blockId, "botany_pot");
                TieredBotanyPotVariantGenerator.generateBlockModel(tier, blockId, "botany_pot", false);
                TieredBotanyPotVariantGenerator.generateItemModel(tier, blockId, "botany_pot");
                TieredBotanyPotVariantGenerator.generateLootTable(tier, blockId, "botany_pot");
                if (blockId != Registry.f_122824_.m_7981_((Object)Blocks.f_50352_)) {
                    TieredBotanyPotVariantGenerator.generateBasicCrafting(tier, blockId);
                }
                TieredBotanyPotVariantGenerator.generateBasicCrafting2(tier, blockId);
                TieredBotanyPotVariantGenerator.generateBlockState(tier, blockId, "hopper_botany_pot");
                TieredBotanyPotVariantGenerator.generateBlockModel(tier, blockId, "hopper_botany_pot", true);
                TieredBotanyPotVariantGenerator.generateItemModel(tier, blockId, "hopper_botany_pot");
                TieredBotanyPotVariantGenerator.generateLootTable(tier, blockId, "hopper_botany_pot");
                TieredBotanyPotVariantGenerator.generateHopperCrafting(tier, blockId);
                if (blockId != Registry.f_122824_.m_7981_((Object)Blocks.f_50352_)) {
                    TieredBotanyPotVariantGenerator.generateCompactHopperCrafting(tier, blockId);
                }
                TieredBotanyPotVariantGenerator.generateCompactHopperCrafting2(tier, blockId);
                TieredBotanyPotVariantGenerator.generateCompactHopperCrafting3(tier, blockId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateCompactHopperCrafting(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_compact_hopper_botany_pot.json"));){
            switch (tier) {
                case ELITE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypots:terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:iron_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:ender_pearl\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case ULTRA: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypotstiers:elite_terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:diamond_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:nether_star\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case CREATIVE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypotstiers:ultra_terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:netherite_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:enchanted_golden_apple\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateCompactHopperCrafting2(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_compact_hopper_botany_pot_2.json"));){
            switch (tier) {
                case ELITE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \" P \",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypots:" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:iron_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:ender_pearl\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case ULTRA: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \" P \",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:elite_" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:diamond_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:nether_star\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case CREATIVE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \" P \",\n        \"IHI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:ultra_" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:netherite_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:enchanted_golden_apple\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateCompactHopperCrafting3(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_compact_hopper_botany_pot_3.json"));){
            switch (tier) {
                case ELITE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypots:" + blockId.m_135815_() + "_hopper_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:iron_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:ender_pearl\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case ULTRA: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:elite_" + blockId.m_135815_() + "_hopper_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:diamond_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:nether_star\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case CREATIVE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:ultra_" + blockId.m_135815_() + "_hopper_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:netherite_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:enchanted_golden_apple\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
            }
            return;
        }
    }

    public static void generateHopperCrafting(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_hopper_botany_pot.json"));){
            writer.append("{\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"ingredients\": [\n        {\n            \"item\": \"botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_botany_pot\"\n        },\n        {\n            \"item\": \"minecraft:hopper\"\n        }\n    ],\n    \"result\": {\n        \"item\": \"" + potId + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateBasicCrafting(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_botany_pot.json"));){
            switch (tier) {
                case ELITE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"ISI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypots:terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:iron_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:ender_pearl\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case ULTRA: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"ISI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypotstiers:elite_terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:diamond_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:nether_star\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case CREATIVE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SES\",\n        \"SPS\",\n        \"ISI\"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"botanypotstiers:ultra_terracotta_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:netherite_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:enchanted_golden_apple\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateBasicCrafting2(PotTiers tier, ResourceLocation blockId) throws IOException {
        String potId = "botanypotstiers:" + tier.getName() + "_" + blockId.m_135815_() + "_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, tier.getName() + "_" + blockId.m_135815_() + "_botany_pot_2.json"));){
            switch (tier) {
                case ELITE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypots:" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:iron_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:ender_pearl\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case ULTRA: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:elite_" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:diamond_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:nether_star\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
                case CREATIVE: {
                    writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \" E \",\n        \"IPI\"\n    ],\n    \"key\": {\n        \"P\": {\n            \"item\": \"botanypotstiers:ultra_" + blockId.m_135815_() + "_botany_pot\"\n        },\n        \"I\": {\n            \"item\": \"minecraft:netherite_block\"\n        },\n        \"E\": {\n            \"item\": \"minecraft:enchanted_golden_apple\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
                    return;
                }
            }
            return;
        }
    }

    public static void generateLootTable(PotTiers tier, ResourceLocation blockId, String suffix) throws IOException {
        String potId = tier.getName() + "_" + blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(lootDir, potId + ".json"));){
            writer.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:copy_name\",\n              \"source\": \"block_entity\"\n            }\n          ],\n          \"name\": \"botanypotstiers:" + potId + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
        }
    }

    public static void generateBlockState(PotTiers tier, ResourceLocation blockId, String suffix) throws IOException {
        String potId = tier.getName() + "_" + blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(stateDir, potId + ".json"));){
            writer.append("{\n    \"variants\": {\n        \"\": {\n            \"model\": \"botanypotstiers:block/" + potId + "\"\n        }\n    }\n}");
        }
    }

    public static void generateItemModel(PotTiers tier, ResourceLocation blockId, String suffix) throws IOException {
        String potId = tier.getName() + "_" + blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(itemDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypotstiers:block/" + potId + "\"\n}");
        }
    }

    public static void generateBlockModel(PotTiers tier, ResourceLocation blockId, String suffix, boolean hopper) throws IOException {
        String potId = tier.getName() + "_" + blockId.m_135815_() + "_" + suffix;
        String parent = hopper ? "hopper_botany_pot_base" : "botany_pot_base";
        try (FileWriter writer = new FileWriter(new File(blockDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypotstiers:block/" + parent + "\",\n    \"textures\": {\n        \"terracotta\": \"minecraft:block/" + blockId.m_135815_() + "\",\n        \"stripe\": \"botanypotstiers:block/" + tier.getName() + "\",\n        \"particle\": \"minecraft:block/" + blockId.m_135815_() + "\"\n    }\n}");
        }
    }

    private static File makeDir(String path) {
        File dir = new File(new File("datagen_out"), path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

