/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.block;

import com.ultramega.botanypotstiers.Constants;
import com.ultramega.botanypotstiers.PotTiers;
import com.ultramega.botanypotstiers.block.TieredBlockBotanyPot;
import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TieredBlockEntityBotanyPot
extends BlockEntityBotanyPot {
    final Random rng = new Random();
    private long rngSeed;
    private final PotTiers tier;

    public TieredBlockEntityBotanyPot(PotTiers tier, BlockPos pos, BlockState state) {
        super((BlockEntityType)RegistryObject.deferred((Registry)Registry.f_122830_, (String)"botanypotstiers", (String)(tier.getName() + "_botany_pot")).cast().get(), pos, state);
        this.tier = tier;
        this.refreshRandom2();
    }

    public boolean getDoneGrowing() {
        return this.doneGrowing;
    }

    public void refreshRandom2() {
        this.rngSeed = Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    public boolean isHopper() {
        Block block;
        if (this.m_58904_() != null && (block = this.m_58904_().m_8055_(this.m_58899_()).m_60734_()) instanceof TieredBlockBotanyPot) {
            TieredBlockBotanyPot potBlock = (TieredBlockBotanyPot)block;
            return potBlock.hasInventory();
        }
        return false;
    }

    public boolean attemptAutoHarvest() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && this.getCrop() != null) {
            ContainerInventoryAccess inventory = new ContainerInventoryAccess((Container)((BotanyPotContainer)this.getInventory()));
            this.rng.setSeed(this.rngSeed);
            List drops = BotanyPotHelper.generateDrop((Random)this.rng, (Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockEntityBotanyPot)this, (Crop)this.getCrop());
            if (drops.isEmpty()) {
                return true;
            }
            boolean didCollect = false;
            for (ItemStack drop : drops) {
                if (drop.m_41619_()) continue;
                drop.m_41764_(drop.m_41613_() * this.tier.getMultiplier());
                int originalSize = drop.m_41613_();
                for (int slot : BotanyPotContainer.STORAGE_SLOT) {
                    if (drop.m_41619_()) break;
                    drop = inventory.insert(slot, drop, Direction.UP, true, true);
                }
                if (drop.m_41613_() == originalSize) continue;
                didCollect = true;
            }
            return didCollect;
        }
        return false;
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, TieredBlockEntityBotanyPot pot) {
        if (pot.m_58901_() || pot.m_58904_() == null) {
            return;
        }
        ((BotanyPotContainer)pot.getInventory()).update();
        Soil soil = pot.getSoil();
        Crop crop = pot.getCrop();
        if (soil != null) {
            soil.onTick(level, pos, (BlockEntityBotanyPot)pot);
        }
        if (crop != null) {
            crop.onTick(level, pos, (BlockEntityBotanyPot)pot);
        }
        if (pot.isHopper()) {
            if (pot.exportDelay > 0) {
                --pot.exportDelay;
            }
            if (pot.harvestDelay > 0) {
                --pot.harvestDelay;
            }
            if (pot.isCropHarvestable() && crop != null && pot.harvestDelay < 1) {
                if (pot.attemptAutoHarvest()) {
                    pot.resetGrowth();
                }
                pot.harvestDelay = 50;
            }
            if (pot.exportDelay < 1) {
                pot.attemptExport();
                pot.exportDelay = 10;
            }
        }
        if (soil != null && crop != null && pot.areGrowthConditionsMet()) {
            if (!pot.doneGrowing) {
                boolean finishedGrowing;
                pot.growthTime += pot.tier.getSpeed();
                soil.onGrowthTick(level, pos, (BlockEntityBotanyPot)pot, crop);
                crop.onGrowthTick(level, pos, (BlockEntityBotanyPot)pot, soil);
                pot.prevComparatorLevel = pot.comparatorLevel;
                pot.comparatorLevel = Mth.m_14143_((float)(15.0f * ((float)pot.growthTime / (float)((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime())));
                boolean bl = finishedGrowing = pot.growthTime >= ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
                if (pot.doneGrowing != finishedGrowing) {
                    pot.doneGrowing = finishedGrowing;
                    pot.markDirty();
                }
            }
        } else if (pot.growthTime != -1 || pot.doneGrowing || pot.comparatorLevel != 0) {
            pot.resetGrowth();
        }
        if (pot.comparatorLevel != pot.prevComparatorLevel) {
            pot.prevComparatorLevel = pot.comparatorLevel;
            pot.f_58857_.m_46717_(pot.f_58858_, pot.m_58900_().m_60734_());
        }
    }

    private void attemptExport() {
        IInventoryAccess exportTo;
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && (exportTo = Services.INVENTORY_HELPER.getInventory(this.m_58904_(), this.m_58899_().m_7495_(), Direction.UP)) != null) {
            block0: for (int potSlotId : BotanyPotContainer.STORAGE_SLOT) {
                ItemStack potStack = ((BotanyPotContainer)this.getInventory()).m_8020_(potSlotId);
                if (potStack.m_41619_()) continue;
                for (int exportSlotId : exportTo.getAvailableSlots()) {
                    if (exportTo.insert(exportSlotId, potStack, Direction.UP, false).m_41613_() == potStack.m_41613_()) continue;
                    ((BotanyPotContainer)this.getInventory()).m_6836_(potSlotId, exportTo.insert(exportSlotId, potStack, Direction.UP, true));
                    continue block0;
                }
            }
        }
    }

    public void resetGrowth() {
        this.growthTime = -1;
        this.comparatorLevel = 0;
        this.prevComparatorLevel = 0;
        this.doneGrowing = false;
        this.refreshRandom2();
        this.markDirty();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rngSeed = (Long)Serializers.LONG.fromNBT(tag, "RandomSeed", (Object)Constants.RANDOM.nextLong());
        this.rng.setSeed(this.rngSeed);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        Serializers.LONG.toNBT(tag, "RandomSeed", (Object)this.rngSeed);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)("block.botanypotstiers." + this.tier.getName() + "_terracotta_botany_pot"));
    }
}

