/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import com.google.common.collect.Range;
import de.melanx.botanicalmachinery.blocks.base.WorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.crafting.recipe.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;

public class BlockEntityMechanicalBrewery
extends WorkingTile<BotanicalBreweryRecipe> {
    public static final int MAX_MANA_PER_TICK = 50;
    public static final List<Item> BREW_CONTAINER = List.of(BotaniaItems.vial.m_5456_(), BotaniaItems.flask.m_5456_(), BotaniaItems.incenseStick.m_5456_(), BotaniaItems.bloodPendant.m_5456_());
    private final BaseItemStackHandler inventory;
    private ItemStack currentOutput = ItemStack.f_41583_;

    public BlockEntityMechanicalBrewery(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, BotaniaRecipeTypes.BREW_TYPE, pos, state, LibXServerConfig.MaxManaCapacity.mechanicalBrewery, 1, 7);
        this.inventory = BaseItemStackHandler.builder((int)8).validator(stack -> BREW_CONTAINER.contains(stack.m_41720_()) && (stack.m_41783_() == null || !stack.m_41783_().m_128441_("brewKey")), new int[]{0}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)BotaniaRecipeTypes.BREW_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7))).output(new int[]{7}).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
    }

    public void tick() {
        Item item;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.runRecipeTick();
            if (this.recipe != null) {
                this.currentOutput = ((BotanicalBreweryRecipe)this.recipe).getOutput(this.inventory.getStackInSlot(0));
                this.m_6596_();
                this.setDispatchable();
            } else if (!this.currentOutput.m_41619_()) {
                this.currentOutput = ItemStack.f_41583_;
                this.m_6596_();
                this.setDispatchable();
            }
        } else if (this.f_58857_ != null && this.getProgress() > 0 && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.mechanicalBrewery && (item = this.currentOutput.m_41720_()) instanceof BrewItem) {
            BrewItem item2 = (BrewItem)item;
            if (this.f_58857_.f_46441_.m_188501_() < 0.5f) {
                int segments = 3;
                for (int i = 1; i <= 6; ++i) {
                    if (this.inventory.getStackInSlot(i).m_41619_()) continue;
                    ++segments;
                }
                if ((double)this.getProgress() < (double)(segments - 1) * ((double)this.getMaxProgress() / (double)segments) && (double)this.getProgress() > (double)(segments - 2) * ((double)this.getMaxProgress() / (double)segments)) {
                    int targetColor = item2.getBrew(this.currentOutput).getColor(this.currentOutput);
                    float red = (float)(targetColor >> 16 & 0xFF) / 255.0f;
                    float green = (float)(targetColor >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(targetColor & 0xFF) / 255.0f;
                    WispParticleData data = WispParticleData.wisp((float)0.125f, (float)red, (float)green, (float)blue, (float)0.5f);
                    double xPos = (double)this.f_58858_.m_123341_() + 0.25 + this.f_58857_.f_46441_.m_188500_() / 2.0;
                    double zPos = (double)this.f_58858_.m_123343_() + 0.25 + this.f_58857_.f_46441_.m_188500_() / 2.0;
                    this.f_58857_.m_7106_((ParticleOptions)data, xPos, (double)this.f_58858_.m_123342_() + 0.35, zPos, 0.0, 0.01 + this.f_58857_.f_46441_.m_188500_() / 18.0, 0.0);
                }
            }
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot == 7;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canMatchRecipes() {
        return !this.inventory.getStackInSlot(0).m_41619_() && BREW_CONTAINER.contains(this.inventory.getStackInSlot(0).m_41720_());
    }

    @Override
    protected List<ItemStack> resultItems(BotanicalBreweryRecipe recipe, List<ItemStack> stacks) {
        return List.of(recipe.getOutput(this.inventory.getStackInSlot(0)));
    }

    @Override
    protected void onCrafted(BotanicalBreweryRecipe recipe) {
        this.inventory.getUnrestricted().extractItem(0, 1, false);
    }

    @Override
    protected int getMaxProgress(BotanicalBreweryRecipe recipe) {
        return recipe.getManaUsage();
    }

    @Override
    public int getMaxManaPerTick() {
        return 50 * LibXServerConfig.WorkingDurationMultiplier.mechanicalBrewery;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag tankTag = new CompoundTag();
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        CompoundTag tankTag = new CompoundTag();
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
        return nbt;
    }
}

