/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityMechanicalManaPool;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.moddingx.libx.render.block.RotatedBlockRenderer;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;

public class MechanicalManaPoolRenderer
extends RotatedBlockRenderer<BlockEntityMechanicalManaPool> {
    public static final double INNER_POOL_HEIGHT = 0.28125;
    public static final double POOL_BOTTOM_HEIGHT = 0.071875;

    protected void doRender(@Nonnull BlockEntityMechanicalManaPool tile, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Block block;
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalManaPool) {
            return;
        }
        ItemStack catalystStack = tile.getInventory().getStackInSlot(0);
        if (!catalystStack.m_41619_() && catalystStack.m_41720_() instanceof BlockItem && (block = ((BlockItem)catalystStack.m_41720_()).m_40614_()) instanceof PoolOverlayProvider) {
            PoolOverlayProvider catalyst = (PoolOverlayProvider)block;
            ResourceLocation spriteId = catalyst.getIcon(tile.m_58904_(), tile.m_58899_());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteId);
            poseStack.m_85836_();
            poseStack.m_85837_(0.125, 0.071875, 0.125);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + partialTick) / 20.0) + 1.0) * 0.3 + 0.2);
            VertexConsumer vertex = buffer.m_6299_(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIconFullBright((PoseStack)poseStack, (VertexConsumer)vertex, (TextureAtlasSprite)sprite, (float)alpha);
            poseStack.m_85849_();
        }
        if (tile.getCurrentMana() > 0) {
            double amount = (double)tile.getCurrentMana() / (double)tile.getMaxMana();
            poseStack.m_85836_();
            poseStack.m_85837_(0.1875, 0.071875 + amount * 0.28125, 0.1875);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85841_(0.625f, 0.625f, 0.625f);
            VertexConsumer vertex = buffer.m_6299_(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIconFullBright((PoseStack)poseStack, (VertexConsumer)vertex, (TextureAtlasSprite)MiscellaneousModels.INSTANCE.manaWater.m_119204_(), (float)1.0f);
            poseStack.m_85849_();
        }
        ItemStack input = tile.getInventory().getStackInSlot(1);
        ItemStack output = tile.getInventory().getStackInSlot(2);
        if (!input.m_41619_() || !output.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.3125, 0.4375, 0.5);
            if (!output.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_85841_(0.4375f, 0.4375f, 0.4375f);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)ClientTickHandler.ticksInGame + partialTick));
                Minecraft.m_91087_().m_91291_().m_174269_(output, ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, (int)tile.m_58899_().m_121878_());
                poseStack.m_85849_();
            }
            poseStack.m_85837_(0.375, 0.0, 0.0);
            if (!input.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_85841_(0.4375f, 0.4375f, 0.4375f);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(ClientTickHandler.ticksInGame % 360)));
                Minecraft.m_91087_().m_91291_().m_174269_(input, ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, (int)tile.m_58899_().m_121878_());
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }
}

