/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;

public class VineBallEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.m_135353_(VineBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Map<Direction, BooleanProperty> propMap = ImmutableMap.of((Object)Direction.NORTH, (Object)VineBlock.f_57834_, (Object)Direction.SOUTH, (Object)VineBlock.f_57836_, (Object)Direction.WEST, (Object)VineBlock.f_57837_, (Object)Direction.EAST, (Object)VineBlock.f_57835_);

    public VineBallEntity(EntityType<VineBallEntity> type, Level world) {
        super(type, world);
    }

    public VineBallEntity(LivingEntity thrower, boolean gravity) {
        super(BotaniaEntities.VINE_BALL, thrower, thrower.m_9236_());
        this.f_19804_.m_135381_(GRAVITY, (Object)Float.valueOf(gravity ? 0.03f : 0.0f));
    }

    public VineBallEntity(double x, double y, double z, Level worldIn) {
        super(BotaniaEntities.VINE_BALL, x, y, z, worldIn);
        this.f_19804_.m_135381_(GRAVITY, (Object)Float.valueOf(0.03f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(GRAVITY, (Object)Float.valueOf(0.0f));
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            for (int j = 0; j < 16; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)BotaniaItems.vineBall)), this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.random() * 0.2 - 0.1, Math.random() * 0.25, Math.random() * 0.2 - 0.1);
            }
        }
    }

    private void effectAndDieWithDrop() {
        this.effectAndDie();
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)BotaniaItems.vineBall));
        itemEntity.m_32060_();
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    private void effectAndDie() {
        this.m_9236_().m_7605_((Entity)this, (byte)3);
        this.m_146870_();
    }

    protected void m_5790_(@NotNull EntityHitResult hit) {
        super.m_5790_(hit);
        if (!this.m_9236_().f_46443_) {
            this.effectAndDieWithDrop();
        }
    }

    protected void m_8060_(@NotNull BlockHitResult hit) {
        if (!this.m_9236_().f_46443_) {
            Direction dir = hit.m_82434_();
            BlockPos pos = hit.m_82425_();
            BlockState hitState = this.m_9236_().m_8055_(hit.m_82425_());
            if (!hitState.m_60713_(BotaniaBlocks.solidVines)) {
                pos = pos.m_121945_(dir);
            }
            int vinesPlaced = 0;
            if (dir.m_122434_() != Direction.Axis.Y) {
                while (pos.m_123342_() > this.m_9236_().m_6042_().f_156647_() && vinesPlaced < 9) {
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (state.m_60767_().m_76336_() && !state.m_60713_(BotaniaBlocks.solidVines)) {
                        BlockState stateToPlace = (BlockState)BotaniaBlocks.solidVines.m_49966_().m_61124_((Property)propMap.get(dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                        if (!stateToPlace.m_60710_((LevelReader)this.m_9236_(), pos)) break;
                        this.m_9236_().m_46597_(pos, stateToPlace);
                        this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)stateToPlace));
                        ++vinesPlaced;
                    }
                    if (!this.m_9236_().m_8055_(pos).m_60713_(BotaniaBlocks.solidVines)) break;
                    pos = pos.m_7495_();
                }
            }
            if (vinesPlaced == 0) {
                this.effectAndDieWithDrop();
            } else {
                this.effectAndDie();
            }
        }
    }

    protected float m_7139_() {
        return ((Float)this.f_19804_.m_135370_(GRAVITY)).floatValue();
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)BotaniaItems.vineBall);
    }
}

