/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaPool;

public abstract class FunctionalFlowerBlockEntity
extends BindableSpecialFlowerBlockEntity<ManaPool> {
    private static final ResourceLocation POOL_ID = new ResourceLocation("botania", "mana_pool");
    public static final int LINK_RANGE = 10;
    private static final String TAG_MANA = "mana";
    private int mana;
    public int redstoneSignal = 0;

    public FunctionalFlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ManaPool.class);
    }

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.drawManaFromPool();
        this.redstoneSignal = 0;
        if (this.acceptsRedstone()) {
            for (Direction dir : Direction.values()) {
                int redstoneSide = this.m_58904_().m_46681_(this.m_58899_().m_121945_(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.m_58904_().f_46443_) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.3 + Math.random() * 0.5, (double)this.m_58899_().m_123342_() + 0.5 + Math.random() * 0.5, (double)this.m_58899_().m_123343_() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    @Override
    public int getBindingRadius() {
        return 10;
    }

    @Override
    @Nullable
    public BlockPos findClosestTarget() {
        ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        ManaPool closestPool = network.getClosestPool(this.m_58899_(), this.m_58904_(), this.getBindingRadius());
        return closestPool == null ? null : closestPool.getManaReceiverPos();
    }

    public void drawManaFromPool() {
        ManaPool pool = (ManaPool)this.findBoundTile();
        if (pool != null) {
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.receiveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public void addMana(int mana) {
        this.mana = Mth.m_14045_((int)(this.mana + mana), (int)0, (int)this.getMaxMana());
        this.m_6596_();
    }

    @Override
    public ItemStack getDefaultHudIcon() {
        return Registry.f_122827_.m_6612_(POOL_ID).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_MANA, this.mana);
    }

    public static class FunctionalWandHud<F extends FunctionalFlowerBlockEntity>
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<F> {
        public FunctionalWandHud(F flower) {
            super(flower);
        }
    }
}

