/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class WitheredBoneLootModifier
extends LootModifier {
    private final Item replacedItem;
    private final Item boneItem;
    public static final Supplier<Codec<WitheredBoneLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> WitheredBoneLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("replaces").forGetter(m -> m.replacedItem), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("bone").forGetter(m -> m.boneItem))).apply((Applicative)inst, WitheredBoneLootModifier::new)));

    protected WitheredBoneLootModifier(LootItemCondition[] conditionsIn, Item replacedItem, Item boneItem) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.boneItem = boneItem;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity t = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (t == null) {
            return generatedLoot;
        }
        if (t instanceof WitherSkeleton) {
            int amountOfBones = 0;
            for (ItemStack i2 : generatedLoot) {
                if (i2.m_41720_() != this.replacedItem) continue;
                amountOfBones += i2.m_41613_();
            }
            generatedLoot.removeIf(i -> i.m_41720_() == this.replacedItem);
            generatedLoot.add((Object)new ItemStack((ItemLike)this.boneItem, amountOfBones));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

