/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.boss.MinibossItem;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.json.WeightedJsonReloadListener;

public class MinibossManager
extends WeightedJsonReloadListener<MinibossItem> {
    public static final MinibossManager INSTANCE = new MinibossManager();

    public MinibossManager() {
        super(AdventureModule.LOGGER, "minibosses", false, false);
    }

    protected void validateItem(MinibossItem item) {
        super.validateItem((TypeKeyed)item);
        item.validate();
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, MinibossItem.SERIALIZER);
    }

    public static interface IEntityMatch {
        @Nullable
        public Set<EntityType<?>> getEntities();

        public static <T extends IEntityMatch> Predicate<T> matches(EntityType<?> type) {
            return obj -> {
                Set<EntityType<?>> types = obj.getEntities();
                return types == null || types.isEmpty() || types.contains(type);
            };
        }

        public static <T extends IEntityMatch> Predicate<T> matches(Entity entity) {
            return IEntityMatch.matches(entity.m_6095_());
        }
    }
}

