/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemInstance;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.event.GetItemSocketsEvent;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.CachedObject;

public class SocketHelper {
    public static final ResourceLocation GEMS_CACHED_OBJECT = Apotheosis.loc("gems");
    public static final String AFFIX_DATA = "affix_data";
    public static final String GEMS = "gems";

    public static List<ItemStack> getGems(ItemStack stack) {
        return (List)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)GEMS_CACHED_OBJECT, SocketHelper::getGemsImpl, (ToIntFunction)CachedObject.hashSubkey((String)AFFIX_DATA));
    }

    private static List<ItemStack> getGemsImpl(ItemStack stack) {
        int size = SocketHelper.getSockets(stack);
        if (size == 0 || stack.m_41619_()) {
            return Collections.emptyList();
        }
        NonNullList gems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        int i = 0;
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(GEMS)) {
            ListTag gemData = afxData.m_128437_(GEMS, 10);
            for (Tag tag : gemData) {
                ItemStack gemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                gemStack.m_41764_(1);
                if (GemInstance.unsocketed(gemStack).isValidUnsocketed()) {
                    gems.set(i++, gemStack);
                }
                if (i < size) continue;
                break;
            }
        }
        return ImmutableList.copyOf((Collection)gems);
    }

    public static Stream<GemInstance> getGemInstances(ItemStack stack) {
        return SocketHelper.getGems(stack).stream().map(gemStack -> new GemInstance(stack, (ItemStack)gemStack)).filter(GemInstance::isValid);
    }

    public static List<Gem> getActiveGems(ItemStack stack) {
        return SocketHelper.getGems(stack).stream().map(GemItem::getGem).filter(Objects::nonNull).toList();
    }

    public static void setGems(ItemStack stack, List<ItemStack> gems) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        ListTag gemData = new ListTag();
        for (ItemStack s : gems) {
            gemData.add((Object)s.m_41739_(new CompoundTag()));
        }
        afxData.m_128365_(GEMS, (Tag)gemData);
    }

    public static int getSockets(ItemStack stack) {
        AffixInstance socketAffix = AffixHelper.getAffixes(stack).get(Apoth.Affixes.SOCKET.get());
        int sockets = socketAffix != null ? (int)socketAffix.level() : 0;
        GetItemSocketsEvent event = new GetItemSocketsEvent(stack, sockets);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getSockets();
    }

    public static void setSockets(ItemStack stack, int sockets) {
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        affixes.put((Affix)Apoth.Affixes.SOCKET.get(), new AffixInstance((Affix)Apoth.Affixes.SOCKET.get(), stack, LootRarity.COMMON, sockets));
        AffixHelper.setAffixes(stack, affixes);
    }

    public static boolean hasEmptySockets(ItemStack stack) {
        return SocketHelper.getGems(stack).stream().map(GemItem::getGem).anyMatch(Objects::isNull);
    }

    public static int getFirstEmptySocket(ItemStack stack) {
        List<ItemStack> gems = SocketHelper.getGems(stack);
        for (int socket = 0; socket < gems.size(); ++socket) {
            Gem gem = GemItem.getGem(gems.get(socket));
            if (gem != null) continue;
            return socket;
        }
        return 0;
    }
}

