/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.pneumaticcraft;

import ad_astra_giselle_addon.common.compat.pneumaticcraft.AddonCommonUpgradeHandlers;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.AddonPneumaticCraftConfig;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.LivingGravityNormalizingProvidingEvent;
import ad_astra_giselle_addon.common.content.proof.LivingSpaceFireProofProvidingEvent;
import ad_astra_giselle_addon.common.content.proof.LivingSpaceOxygenProofProvidingEvent;
import ad_astra_giselle_addon.common.content.proof.LivingVenusAcidProofProvidingEvent;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.content.proof.ProofSession;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import com.google.common.eventbus.Subscribe;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class PneumaticCraftProofProvidingHandler {
    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
            int airSupply = player.m_20146_();
            int maxAirSupply = player.m_6062_();
            if (maxAirSupply - airSupply >= 30) {
                ItemStack stack = PneumaticCraftProofProvidingHandler.getUpgradeUsablePneumaticArmorItem(player, AddonCommonUpgradeHandlers.SPACE_BREATHING);
                long oxygenUsing = ProofAbstractUtils.OXYGEN_PROOF_USING;
                IOxygenCharger oxygenCharger = OxygenChargerUtils.firstExtractable((LivingEntity)player, oxygenUsing);
                if (!stack.m_41619_() && oxygenCharger != null) {
                    IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElse(null);
                    int airUsing = AddonPneumaticCraftConfig.SPACE_BREATHING_AIR_USING;
                    if (airHandler != null && this.useAir(player, airHandler, airUsing, true)) {
                        if (!player.m_9236_().m_5776_() && LivingHelper.isPlayingMode((LivingEntity)player)) {
                            UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
                            FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, false);
                            this.useAir(player, airHandler, airUsing, false);
                        }
                        player.m_20301_(airSupply + 30);
                    }
                }
            }
        }
    }

    @Subscribe
    public void onLivingSpaceOxygenProof(LivingSpaceOxygenProofProvidingEvent e) {
        e.add(l -> {
            long oxygenUsing;
            IOxygenCharger oxygenCharger;
            if (!(l instanceof Player)) {
                return null;
            }
            final Player player = (Player)l;
            ItemStack stack = PneumaticCraftProofProvidingHandler.getUpgradeUsablePneumaticArmorItem(player, AddonCommonUpgradeHandlers.SPACE_BREATHING);
            if (stack.m_41619_()) {
                return null;
            }
            final IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElse(null);
            final int airUsing = AddonPneumaticCraftConfig.SPACE_BREATHING_AIR_USING;
            if (airHandler != null && this.useAir(player, airHandler, airUsing, true) && (oxygenCharger = OxygenChargerUtils.firstExtractable((LivingEntity)player, oxygenUsing = ProofAbstractUtils.OXYGEN_PROOF_USING)) != null) {
                return new ProofSession((LivingEntity)l){

                    @Override
                    public void onProvide() {
                        LivingEntity living = this.getLiving();
                        if (!living.m_9236_().m_5776_() && LivingHelper.isPlayingMode(living)) {
                            UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
                            FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, false);
                            PneumaticCraftProofProvidingHandler.this.useAir(player, airHandler, airUsing, false);
                        }
                    }

                    @Override
                    public int getProofDuration() {
                        return 30;
                    }
                };
            }
            return null;
        });
    }

    @Subscribe
    public void onLivingSpaceFireProof(LivingSpaceFireProofProvidingEvent e) {
        e.add(new Function<LivingEntity, ProofSession>(){

            @Override
            public ProofSession apply(LivingEntity living) {
                return new ProofSession(living){

                    @Override
                    public boolean canProvide() {
                        return PneumaticCraftProofProvidingHandler.this.useAir(this.getLiving(), (IArmorUpgradeHandler<?>)AddonCommonUpgradeHandlers.SPACE_FIRE_PROOF, AddonPneumaticCraftConfig.SPACE_FIRE_PROOF_AIR_USING);
                    }

                    @Override
                    public int getProofDuration() {
                        return 10;
                    }
                };
            }
        });
    }

    @Subscribe
    public void onLivingVenusAcidProof(LivingVenusAcidProofProvidingEvent e) {
        e.add(new Function<LivingEntity, ProofSession>(){

            @Override
            public ProofSession apply(LivingEntity living) {
                return new ProofSession(living){

                    @Override
                    public boolean canProvide() {
                        return PneumaticCraftProofProvidingHandler.this.useAir(this.getLiving(), (IArmorUpgradeHandler<?>)AddonCommonUpgradeHandlers.ACID_RAIN_PROOF, AddonPneumaticCraftConfig.ACID_RAIN_PROOF_AIR_USING);
                    }

                    @Override
                    public int getProofDuration() {
                        return 10;
                    }
                };
            }
        });
    }

    @Subscribe
    public void onLivingGravityNormalizing(LivingGravityNormalizingProvidingEvent e) {
        e.add(new Function<LivingEntity, ProofSession>(){

            @Override
            public ProofSession apply(LivingEntity living) {
                return new ProofSession(living){

                    @Override
                    public boolean canProvide() {
                        return PneumaticCraftProofProvidingHandler.this.useAir(this.getLiving(), (IArmorUpgradeHandler<?>)AddonCommonUpgradeHandlers.GRAVITY_NORMALIZING, AddonPneumaticCraftConfig.GRAVITY_NORMALIZING_AIR_USING);
                    }

                    @Override
                    public int getProofDuration() {
                        return 10;
                    }
                };
            }
        });
    }

    public boolean useAir(LivingEntity living, IArmorUpgradeHandler<?> upgradeHandler, int airUsing) {
        if (!(living instanceof Player)) {
            return false;
        }
        Player player = (Player)living;
        ItemStack stack = PneumaticCraftProofProvidingHandler.getUpgradeUsablePneumaticArmorItem(player, upgradeHandler);
        if (stack.m_41619_()) {
            return false;
        }
        IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (airHandler != null && this.useAir(player, airHandler, airUsing, true)) {
            if (!player.m_9236_().m_5776_()) {
                this.useAir(player, airHandler, airUsing, false);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static ItemStack getUpgradeUsablePneumaticArmorItem(Player player, IArmorUpgradeHandler<?> upgradeHandler) {
        CommonArmorHandler commonHandler;
        ItemStack stack = player.m_6844_(upgradeHandler.getEquipmentSlot());
        if (stack.m_41720_() instanceof PneumaticArmorItem && (commonHandler = CommonArmorHandler.getHandlerForPlayer((Player)player)).upgradeUsable(upgradeHandler, true)) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean useAir(Player player, IAirHandlerItem airHandler, int airUsing, boolean simulate) {
        return !LivingHelper.isPlayingMode((LivingEntity)player) || PneumaticCraftProofProvidingHandler.useAir((IAirHandler)airHandler, airUsing, simulate);
    }

    public static boolean useAir(IAirHandler airHandler, int airUsing, boolean simulate) {
        if (airHandler.getAir() >= airUsing) {
            if (!simulate) {
                airHandler.addAir(-airUsing);
            }
            return true;
        }
        return false;
    }
}

