/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.RocketSensingType;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRocketSensingType {
    public static final String LANGUGE_CATEGORY_ROCKET_SENSING_TYPE = "rocket_sensing_type";

    public static List<IRocketSensingType> getRocketSensingTypes() {
        return Arrays.asList(RocketSensingType.values());
    }

    @NotNull
    public static IRocketSensingType find(@Nullable ResourceLocation name) {
        if (name == null) {
            return RocketSensingType.DISABLED;
        }
        for (IRocketSensingType mode : IRocketSensingType.getRocketSensingTypes()) {
            if (!mode.getName().equals((Object)name)) continue;
            return mode;
        }
        return RocketSensingType.DISABLED;
    }

    public static Tag writeNBT(@Nullable IRocketSensingType mode) {
        ResourceLocation name = (mode != null ? mode : RocketSensingType.DISABLED).getName();
        return StringTag.m_129297_((String)name.toString());
    }

    @NotNull
    public static IRocketSensingType readNBT(@Nullable Tag tag) {
        if (tag == null) {
            return RocketSensingType.DISABLED;
        }
        ResourceLocation name = ResourceLocation.m_135820_((String)tag.m_7916_());
        return IRocketSensingType.find(name);
    }

    public ResourceLocation getName();

    public Component getDisplayName();

    public ItemStack getDisplayIcon();

    public List<Component> getTooltip();

    public int getAnalogSignal(Rocket var1);
}

