/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import com.google.common.base.Suppliers;
import io.github.projectet.ae2things.block.BlockAdvancedInscriber;
import io.github.projectet.ae2things.block.entity.BEAdvancedInscriber;
import io.github.projectet.ae2things.client.AE2ThingsClient;
import io.github.projectet.ae2things.command.Command;
import io.github.projectet.ae2things.gui.advancedInscriber.AdvancedInscriberMenu;
import io.github.projectet.ae2things.gui.cell.DISKItemCellGuiHandler;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.util.StorageManager;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ae2things")
public class AE2Things {
    public static final String MOD_ID = "ae2things";
    public static StorageManager STORAGE_INSTANCE = new StorageManager();
    public static final Supplier<CreativeModeTab> ITEM_GROUP = Suppliers.memoize(() -> new CreativeModeTab("ae2things.item_group"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)AETItems.DISK_HOUSING.get());
        }
    });
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registry.f_122901_, (String)"ae2things");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registry.f_122907_, (String)"ae2things");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registry.f_122904_, (String)"ae2things");
    public static final RegistryObject<BlockAdvancedInscriber> ADVANCED_INSCRIBER = BLOCKS.register("advanced_inscriber", () -> new BlockAdvancedInscriber(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155954_(4.0f)));
    public static final RegistryObject<BlockEntityType<BEAdvancedInscriber>> ADVANCED_INSCRIBER_BE = BLOCK_ENTITIES.register("advanced_inscriber_be", () -> BlockEntityType.Builder.m_155273_(BEAdvancedInscriber::new, (Block[])new Block[]{(Block)ADVANCED_INSCRIBER.get()}).m_58966_(null));
    public static final RegistryObject<Item> ADVANCED_INSCRIBER_ITEM = AE2Things.createBlockItem(ADVANCED_INSCRIBER);

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static RegistryObject<Item> createBlockItem(RegistryObject<? extends Block> block) {
        return ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(ITEM_GROUP.get())));
    }

    public AE2Things() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
        AETItems.init();
        modEventBus.addListener(AE2Things::registerMenus);
        modEventBus.addListener(AE2Things::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(Command::commandRegister);
        MinecraftForge.EVENT_BUS.addListener(AE2Things::worldTick);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> AE2ThingsClient::init);
    }

    public static void registerMenus(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registry.f_122913_)) {
            IForgeRegistry registry = Objects.requireNonNull(event.getForgeRegistry());
            registry.register(AE2Things.id("advanced_inscriber"), AdvancedInscriberMenu.ADVANCED_INSCRIBER_SHT);
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        AETItems.commonSetup();
        StorageCells.addCellHandler((ICellHandler)DISKCellHandler.INSTANCE);
        StorageCells.addCellGuiHandler((ICellGuiHandler)new DISKItemCellGuiHandler());
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)((ItemLike)ADVANCED_INSCRIBER.get()), (int)5);
        ((BlockAdvancedInscriber)((Object)ADVANCED_INSCRIBER.get())).setBlockEntity(BEAdvancedInscriber.class, (BlockEntityType)ADVANCED_INSCRIBER_BE.get(), null, null);
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            STORAGE_INSTANCE = StorageManager.getInstance(event.level.m_7654_());
        }
    }
}

