/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.handler.plugins;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.seraphjack.simplelogin.server.handler.HandlerPlugin;
import top.seraphjack.simplelogin.server.handler.Login;

public final class RestrictMovement
implements HandlerPlugin {
    private ScheduledExecutorService executor;
    private final Map<String, ScheduledFuture<?>> futures = new ConcurrentHashMap();

    @Override
    public void enable(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void preLogin(ServerPlayer player, Login login) {
        ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(() -> ServerLifecycleHooks.getCurrentServer().m_6937_((Runnable)new TickTask(1, () -> {
            player.m_6034_(login.posX, login.posY, login.posZ);
            player.f_8906_.m_9774_(login.posX, login.posY, login.posZ, login.rotY, login.rotX);
        })), 0L, 100L, TimeUnit.MILLISECONDS);
        Optional.ofNullable(this.futures.put(login.name, future)).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void postLogin(ServerPlayer player, Login login) {
        Optional.ofNullable(this.futures.remove(login.name)).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void preLogout(ServerPlayer player) {
        Optional.ofNullable(this.futures.remove(player.m_36316_().getName().toLowerCase())).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void disable() {
        this.futures.values().forEach(f -> f.cancel(true));
    }
}

