/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.utils;

import org.apache.commons.lang3.StringUtils;

public class Version
implements Comparable {
    private String version;
    private int[] sub;

    public Version(String version) {
        if (version == null) {
            version = "";
        }
        this.version = version;
        String[] split = version.split("\\.");
        this.sub = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            if (!StringUtils.isNumeric((CharSequence)split[i])) continue;
            this.sub[i] = Integer.parseInt(split[i]);
        }
    }

    public static Version of(String version) {
        return new Version(version);
    }

    public static int compare(String version, String anotherVersion) {
        return Version.of(version).compareTo(anotherVersion);
    }

    public String toString() {
        return this.version;
    }

    public int compareTo(Object o) {
        int i;
        if (o instanceof String) {
            o = Version.of((String)o);
        }
        if (!(o instanceof Version)) {
            throw new IllegalArgumentException(String.format("'%s' is not a Version.", o));
        }
        Version v = (Version)o;
        for (i = 0; i < this.sub.length && i < v.sub.length && this.sub[i] == v.sub[i]; ++i) {
        }
        if (i < this.sub.length && i < v.sub.length) {
            return this.sub[i] < v.sub[i] ? -1 : (this.sub[i] == v.sub[i] ? 0 : 1);
        }
        return Integer.signum(this.sub.length - v.sub.length);
    }
}

