/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.bell;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.bell.AbstractBellBlockEntity;
import com.simibubi.create.content.equipment.bell.HauntedBellPulser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HauntedBellBlockEntity
extends AbstractBellBlockEntity {
    public static final int DISTANCE = 10;
    public static final int RECHARGE_TICKS = 65;
    public static final int EFFECT_TICKS = 20;
    public int effectTicks = 0;

    public HauntedBellBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getBellModel() {
        return AllPartialModels.HAUNTED_BELL;
    }

    @Override
    public boolean ring(Level world, BlockPos pos, Direction direction) {
        if (this.isRinging && this.ringingTicks < 65) {
            return false;
        }
        HauntedBellPulser.sendPulse(world, pos, 10, false);
        this.effectTicks = 20;
        return super.ring(world, pos, direction);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("EffectTicks", this.effectTicks);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.effectTicks = compound.m_128451_("EffectTicks");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.effectTicks <= 0) {
            return;
        }
        --this.effectTicks;
        if (!this.f_58857_.f_46443_) {
            return;
        }
        RandomSource rand = this.f_58857_.m_213780_();
        if (rand.m_188501_() > 0.25f) {
            return;
        }
        this.spawnParticle(rand);
        this.playSound(rand);
    }

    protected void spawnParticle(RandomSource rand) {
        double x = (double)this.f_58858_.m_123341_() + rand.m_188500_();
        double y = (double)this.f_58858_.m_123342_() + 0.5;
        double z = (double)this.f_58858_.m_123343_() + rand.m_188500_();
        double vx = rand.m_188500_() * 0.04 - 0.02;
        double vy = 0.1;
        double vz = rand.m_188500_() * 0.04 - 0.02;
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, vx, vy, vz);
    }

    protected void playSound(RandomSource rand) {
        float vol = rand.m_188501_() * 0.4f + rand.m_188501_() > 0.9f ? 0.6f : 0.0f;
        float pitch = 0.6f + rand.m_188501_() * 0.4f;
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12404_, SoundSource.BLOCKS, vol, pitch);
    }
}

