/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.slidingDoor;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlidingDoorBlock
extends DoorBlock
implements IWrenchable,
IBE<SlidingDoorBlockEntity> {
    public static final BooleanProperty VISIBLE = BooleanProperty.m_61465_((String)"visible");
    private boolean folds;

    public SlidingDoorBlock(BlockBehaviour.Properties p_52737_, boolean folds) {
        super(p_52737_);
        this.folds = folds;
    }

    public boolean isFoldingDoor() {
        return this.folds;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{VISIBLE}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!((Boolean)pState.m_61143_((Property)f_52727_)).booleanValue() && (((Boolean)pState.m_61143_((Property)VISIBLE)).booleanValue() || pLevel instanceof ContraptionWorld)) {
            return super.m_5940_(pState, pLevel, pPos, pContext);
        }
        Direction direction = (Direction)pState.m_61143_((Property)f_52726_);
        boolean hinge = pState.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT;
        return SlidingDoorShapes.get(direction, hinge, this.isFoldingDoor());
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pState.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER || pLevel.m_8055_(pPos.m_7495_()).m_60713_((Block)this);
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return this.m_5940_(pState, pLevel, pPos, CollisionContext.m_82749_());
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement != null && ((Boolean)stateForPlacement.m_61143_((Property)f_52727_)).booleanValue()) {
            return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false));
        }
        return stateForPlacement;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_((Block)this)) {
            this.deferUpdate((LevelAccessor)pLevel, pPos);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockState = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (blockState.m_60795_()) {
            return blockState;
        }
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)blockState.m_61143_((Property)f_52730_);
        if (pFacing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_((Property)f_52730_) != doubleblockhalf ? (BlockState)blockState.m_61124_((Property)VISIBLE, (Comparable)((Boolean)pFacingState.m_61143_((Property)VISIBLE))) : Blocks.f_50016_.m_49966_();
        }
        return blockState;
    }

    public void m_153165_(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.m_60713_((Block)this)) {
            return;
        }
        if ((Boolean)state.m_61143_((Property)f_52727_) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.m_7731_(pos, changedState, 10);
        DoorHingeSide hinge = (DoorHingeSide)changedState.m_61143_((Property)f_52728_);
        Direction facing = (Direction)changedState.m_61143_((Property)f_52726_);
        BlockPos otherPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = level.m_8055_(otherPos);
        if (SlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
            this.m_153165_(entity, level, otherDoor, otherPos, open);
        }
        this.playSound(level, pos, open);
        level.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean lower = pState.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
        boolean isPowered = SlidingDoorBlock.isDoorPowered(pLevel, pPos, pState);
        if (this.m_49966_().m_60713_(pBlock)) {
            return;
        }
        if (isPowered == (Boolean)pState.m_61143_((Property)f_52729_)) {
            return;
        }
        SlidingDoorBlockEntity be = (SlidingDoorBlockEntity)this.getBlockEntity((BlockGetter)pLevel, lower ? pPos : pPos.m_7495_());
        if (be != null && be.deferUpdate) {
            return;
        }
        BlockState changedState = (BlockState)((BlockState)pState.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(isPowered));
        if (isPowered) {
            changedState = (BlockState)changedState.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (isPowered != (Boolean)pState.m_61143_((Property)f_52727_)) {
            this.playSound(pLevel, pPos, isPowered);
            pLevel.m_142346_(null, isPowered ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
            DoorHingeSide hinge = (DoorHingeSide)changedState.m_61143_((Property)f_52728_);
            Direction facing = (Direction)changedState.m_61143_((Property)f_52726_);
            BlockPos otherPos = pPos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
            BlockState otherDoor = pLevel.m_8055_(otherPos);
            if (SlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
                otherDoor = (BlockState)((BlockState)otherDoor.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(isPowered));
                if (isPowered) {
                    otherDoor = (BlockState)otherDoor.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
                }
                pLevel.m_7731_(otherPos, otherDoor, 2);
            }
        }
        pLevel.m_7731_(pPos, changedState, 2);
    }

    public static boolean isDoorPowered(Level pLevel, BlockPos pPos, BlockState state) {
        boolean lower = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)f_52728_);
        Direction facing = (Direction)state.m_61143_((Property)f_52726_);
        BlockPos otherPos = pPos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = pLevel.m_8055_(otherPos);
        if (SlidingDoorBlock.isDoubleDoor((BlockState)state.m_61122_((Property)f_52727_), hinge, facing, otherDoor) && (pLevel.m_46753_(otherPos) || pLevel.m_46753_(otherPos.m_121945_(lower ? Direction.UP : Direction.DOWN)))) {
            return true;
        }
        return pLevel.m_46753_(pPos) || pLevel.m_46753_(pPos.m_121945_(lower ? Direction.UP : Direction.DOWN));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (((Boolean)(pState = (BlockState)pState.m_61122_((Property)f_52727_)).m_61143_((Property)f_52727_)).booleanValue()) {
            pState = (BlockState)pState.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        pLevel.m_7731_(pPos, pState, 10);
        pLevel.m_142346_((Entity)pPlayer, this.m_52815_(pState) ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
        DoorHingeSide hinge = (DoorHingeSide)pState.m_61143_((Property)f_52728_);
        Direction facing = (Direction)pState.m_61143_((Property)f_52726_);
        BlockPos otherPos = pPos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState otherDoor = pLevel.m_8055_(otherPos);
        if (SlidingDoorBlock.isDoubleDoor(pState, hinge, facing, otherDoor)) {
            this.m_6227_(otherDoor, pLevel, otherPos, pPlayer, pHand, pHit);
        } else if (((Boolean)pState.m_61143_((Property)f_52727_)).booleanValue()) {
            pLevel.m_5898_(pPlayer, this.getOpenSound(), pPos, 0);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void deferUpdate(LevelAccessor level, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)level, pos, sdte -> {
            sdte.deferUpdate = true;
        });
    }

    public static boolean isDoubleDoor(BlockState pState, DoorHingeSide hinge, Direction facing, BlockState otherDoor) {
        return otherDoor.m_60734_() == pState.m_60734_() && otherDoor.m_61143_((Property)f_52728_) != hinge && otherDoor.m_61143_((Property)f_52726_) == facing && otherDoor.m_61143_((Property)f_52727_) != pState.m_61143_((Property)f_52727_) && otherDoor.m_61143_((Property)f_52730_) == pState.m_61143_((Property)f_52730_);
    }

    public RenderShape m_7514_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    private void playSound(Level pLevel, BlockPos pPos, boolean pIsOpening) {
        if (pIsOpening) {
            pLevel.m_5898_((Player)null, this.getOpenSound(), pPos, 0);
        }
    }

    private int getOpenSound() {
        return 1005;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return IBE.super.m_142194_(pos, state);
    }

    @Override
    public Class<SlidingDoorBlockEntity> getBlockEntityClass() {
        return SlidingDoorBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SlidingDoorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.SLIDING_DOOR.get();
    }
}

