/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.launch;

import io.github.lxgaming.sledgehammer.launch.GlobalPropertiesProxy;
import io.github.lxgaming.sledgehammer.launch.SledgehammerTweaker;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixins;

public class SledgehammerLaunch {
    private static final Logger LOGGER = LogManager.getLogger((String)"Sledgehammer Launch");
    private static final String DEOBFUSCATED_ENVIRONMENT = "fml.deobfuscatedEnvironment";
    private static final String FORGE_INITIALIZED = "forge.initialized";
    private static final String MIXIN_INITIALIZED = "mixin.initialised";
    private static final String SLEDGEHAMMER_INITIALIZED = "sledgehammer.initialized";
    private static final String SPONGE_INITIALIZED = "sponge.initialized";
    private static final String TWEAK_CLASSES = "TweakClasses";
    private static final String TWEAKS = "Tweaks";
    private static final String FORGE_CLASS = "net.minecraftforge.fml.relauncher.CoreModManager";
    private static final String FORGE_DEOBF_TWEAKER_CLASS = "net.minecraftforge.fml.common.launcher.FMLDeobfTweaker";
    private static final String GRADLE_START_COMMON_CLASS = "net.minecraftforge.gradle.GradleStartCommon";
    private static final String MIXIN_STATE_TWEAKER_CLASS = "org.spongepowered.asm.mixin.EnvironmentStateTweaker";
    private static final String SPONGE_CLASS = "org.spongepowered.common.launch.SpongeLaunch";

    private SledgehammerLaunch() {
    }

    public static void configureClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("io.github.lxgaming.sledgehammer.launch.");
        classLoader.addTransformerExclusion("io.github.lxgaming.sledgehammer.launch.");
        classLoader.addTransformerExclusion("io.github.lxgaming.sledgehammer.lib.");
    }

    public static void configureEnvironment() {
        if (!SledgehammerLaunch.isForgeInitialized() && SledgehammerLaunch.isClassPresent(FORGE_CLASS)) {
            GlobalPropertiesProxy.put(FORGE_INITIALIZED, Boolean.TRUE);
            SledgehammerLaunch.getLogger().debug("Detected Forge");
        }
        if (!SledgehammerLaunch.isSpongeInitialized() && SledgehammerLaunch.isClassPresent(SPONGE_CLASS)) {
            GlobalPropertiesProxy.put(SPONGE_INITIALIZED, Boolean.TRUE);
            SledgehammerLaunch.getLogger().debug("Detected Sponge");
        }
        if (!SledgehammerLaunch.isSledgehammerInitialized() && SledgehammerLaunch.isMixinInitialized() && SledgehammerLaunch.isTweakerQueued(SledgehammerTweaker.class)) {
            GlobalPropertiesProxy.put(SLEDGEHAMMER_INITIALIZED, "1.12.2-2.0.8");
            Mixins.addConfiguration((String)"mixins.sledgehammer.preinit.json");
            SledgehammerLaunch.getLogger().debug("Detected Mixin & SledgehammerTweaker");
        }
    }

    public static boolean isEarly() {
        return !SledgehammerLaunch.isClassPresent(FORGE_CLASS) || SledgehammerLaunch.isClassPresent(GRADLE_START_COMMON_CLASS) || SledgehammerLaunch.isTweakerQueued(FORGE_DEOBF_TWEAKER_CLASS);
    }

    public static boolean isStateTweakerPresent() {
        return SledgehammerLaunch.isTweakerQueued(MIXIN_STATE_TWEAKER_CLASS) && SledgehammerLaunch.isClassPresentInStackTrace(MIXIN_STATE_TWEAKER_CLASS);
    }

    public static boolean isClassPresent(String name) {
        try {
            return Class.forName(name, false, (ClassLoader)Launch.classLoader) != null;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isClassPresentInStackTrace(String className) {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTweakerQueued(Class<? extends ITweaker> tweakerClass) {
        return SledgehammerLaunch.isTweakerQueued(tweakerClass.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTweakerQueued(String tweakerClass) {
        if (SledgehammerLaunch.getTweakerClasses().contains(tweakerClass)) return true;
        if (!SledgehammerLaunch.getTweakers().stream().map(Object::getClass).map(Class::getName).anyMatch(tweakerClass::equals)) return false;
        return true;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static List<String> getTweakerClasses() {
        return (List)GlobalPropertiesProxy.get(TWEAK_CLASSES);
    }

    public static List<ITweaker> getTweakers() {
        return (List)GlobalPropertiesProxy.get(TWEAKS);
    }

    public static String getMixinVersion() {
        return (String)GlobalPropertiesProxy.get(MIXIN_INITIALIZED);
    }

    public static boolean isDeobfuscatedEnvironment() {
        return GlobalPropertiesProxy.get(DEOBFUSCATED_ENVIRONMENT, false);
    }

    public static boolean isForgeInitialized() {
        return GlobalPropertiesProxy.get(FORGE_INITIALIZED) == Boolean.TRUE;
    }

    public static boolean isMixinInitialized() {
        return SledgehammerLaunch.getMixinVersion() != null;
    }

    public static boolean isSledgehammerInitialized() {
        return GlobalPropertiesProxy.get(SLEDGEHAMMER_INITIALIZED) != null;
    }

    public static boolean isSpongeInitialized() {
        return GlobalPropertiesProxy.get(SPONGE_INITIALIZED) == Boolean.TRUE;
    }
}

