/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.StandardEmojiIdPicker;
import net.teamfruit.emojicord.util.DataUtils;

public class Endpoint {
    public static Models.EmojiGateway EMOJI_API = new Models.EmojiGateway();

    public static boolean loadGateway() {
        Models.EmojiGateway data = DataUtils.loadUrl("https://raw.githubusercontent.com/Team-Fruit/Emojicord/api/api.json", Models.EmojiGateway.class, "Emojicord API");
        if (data != null) {
            EMOJI_API = data;
            return true;
        }
        return false;
    }

    public static void loadStandardEmojis() {
        StandardEmojiIdDictionary.StandardEmojiIdDictionaryBuilder builder = new StandardEmojiIdDictionary.StandardEmojiIdDictionaryBuilder();
        for (String emojiUrls : Endpoint.EMOJI_API.emojis) {
            Models.EmojiStandardList emojiList = DataUtils.loadUrl(emojiUrls, Models.EmojiStandardList.class, "Standard Emojis");
            if (emojiList == null) continue;
            for (Models.EmojiStandardGroup emojiGroup : emojiList.groups) {
                for (Models.EmojiStandard emoji : emojiGroup.emojis) {
                    EmojiId.StandardEmojiId id = new EmojiId.StandardEmojiId(emojiGroup.location + emoji.location, emoji.name);
                    builder.putName(emoji.name, id);
                    builder.putUtf(emoji.surrogates, id);
                    for (String string : emoji.strings) {
                        builder.putAlias(string, id);
                    }
                }
            }
        }
        StandardEmojiIdDictionary.instance = builder.build();
    }

    public static void loadStandardPicker() {
        StandardEmojiIdPicker.StandardEmojiIdPickerBuilder builder = new StandardEmojiIdPicker.StandardEmojiIdPickerBuilder();
        for (String emojiUrls : Endpoint.EMOJI_API.picker) {
            Models.EmojiStandardPicker emojiPicker = DataUtils.loadUrl(emojiUrls, Models.EmojiStandardPicker.class, "Standard Emoji Picker");
            if (emojiPicker == null) continue;
            for (Models.EmojiStandardPickerCategory category : emojiPicker.category) {
                builder.addGroup(category.name, category.emojis);
            }
        }
        StandardEmojiIdPicker.instance = builder.build();
    }
}

