/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.compat.top;

import com.google.common.base.Function;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"edgarallen.soundmuffler.compat.top.TOPCompatibility$GetTheOneProbe");
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "supersoundmuffler:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                    TileEntity te = world.func_175625_s(data.getPos());
                    if (te instanceof TileEntitySoundMuffler) {
                        TileEntitySoundMuffler tileEntity = (TileEntitySoundMuffler)te;
                        String key = tileEntity.isWhiteList() ? "item.sound_muffler.tooltip.mode.white_list" : "item.sound_muffler.tooltip.mode.black_list";
                        probeInfo.horizontal().text(I18n.func_135052_a((String)key, (Object[])new Object[0]));
                        probeInfo.horizontal().text(I18n.func_135052_a((String)"item.sound_muffler.tooltip.range", (Object[])new Object[]{tileEntity.getRange()}));
                        List<ResourceLocation> sounds = tileEntity.getMuffledSounds();
                        if (sounds.isEmpty()) {
                            probeInfo.horizontal().text(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{0}));
                        } else {
                            probeInfo.horizontal().text(I18n.func_135052_a((String)"item.sound_muffler.tooltip.sounds.count", (Object[])new Object[]{sounds.size()}));
                            if (GuiScreen.func_146272_n()) {
                                sounds.stream().map(sound -> I18n.func_135052_a((String)"item.sound_muffler.tooltip.sound", (Object[])new Object[]{sound.toString()})).collect(Collectors.toList()).forEach(item -> probeInfo.horizontal().text(item));
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

