/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.ComponentLike;
import me.lucko.spark.lib.adventure.text.PatternReplacementResult;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.TextReplacementConfigImpl;
import me.lucko.spark.lib.adventure.util.Buildable;
import me.lucko.spark.lib.adventure.util.IntFunction2;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;

public interface TextReplacementConfig
extends Buildable<TextReplacementConfig, Builder>,
Examinable {
    public static @NonNull Builder builder() {
        return new TextReplacementConfigImpl.Builder();
    }

    public @NonNull Pattern matchPattern();

    public static interface Builder
    extends Buildable.Builder<TextReplacementConfig> {
        @Contract(value="_ -> this")
        default public Builder matchLiteral(String literal) {
            return this.match(Pattern.compile(literal, 16));
        }

        @Contract(value="_ -> this")
        default public @NonNull Builder match(@RegExp @NonNull String pattern) {
            return this.match(Pattern.compile(pattern));
        }

        @Contract(value="_ -> this")
        public @NonNull Builder match(@NonNull Pattern var1);

        @Contract(value="-> this")
        default public @NonNull Builder once() {
            return this.times(1);
        }

        @Contract(value="_ -> this")
        default public @NonNull Builder times(int times) {
            return this.condition((index, replaced) -> replaced < times ? PatternReplacementResult.REPLACE : PatternReplacementResult.STOP);
        }

        @Contract(value="_ -> this")
        public @NonNull Builder condition(@NonNull IntFunction2<PatternReplacementResult> var1);

        @Contract(value="_ -> this")
        default public @NonNull Builder replacement(@NonNull String replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((TextComponent.Builder builder) -> builder.content(replacement));
        }

        @Contract(value="_ -> this")
        default public @NonNull Builder replacement(@Nullable ComponentLike replacement) {
            @Nullable Component baked = replacement == null ? null : replacement.asComponent();
            return this.replacement((MatchResult result, TextComponent.Builder input) -> baked);
        }

        @Contract(value="_ -> this")
        default public @NonNull Builder replacement(@NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((MatchResult result, TextComponent.Builder input) -> (ComponentLike)replacement.apply((TextComponent.Builder)input));
        }

        @Contract(value="_ -> this")
        public @NonNull Builder replacement(@NonNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> var1);
    }
}

