/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.key;

import java.util.stream.Stream;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.examination.ExaminableProperty;
import me.lucko.spark.lib.adventure.key.KeyImpl;
import me.lucko.spark.lib.adventure.key.Namespaced;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.intellij.lang.annotations.Pattern;

public interface Key
extends Comparable<Key>,
Examinable {
    public static final String MINECRAFT_NAMESPACE = "minecraft";

    public static @NonNull Key key(@Pattern(value="([a-z0-9_\\-.]+:)?[a-z0-9_\\-./]+") @NonNull String string) {
        return Key.key(string, ':');
    }

    public static @NonNull Key key(@NonNull String string, char character) {
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.key(namespace, value);
    }

    public static @NonNull Key key(@NonNull Namespaced namespaced, @Pattern(value="[a-z0-9_\\-./]+") @NonNull String value) {
        return Key.key(namespaced.namespace(), value);
    }

    public static @NonNull Key key(@Pattern(value="[a-z0-9_\\-.]+") @NonNull String namespace, @Pattern(value="[a-z0-9_\\-./]+") @NonNull String value) {
        return new KeyImpl(namespace, value);
    }

    public @NonNull String namespace();

    public @NonNull String value();

    public @NonNull String asString();

    @Override
    default public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NonNull Key that) {
        int value = this.value().compareTo(that.value());
        if (value != 0) {
            return KeyImpl.clampCompare(value);
        }
        return KeyImpl.clampCompare(this.namespace().compareTo(that.namespace()));
    }
}

