/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import me.lucko.spark.common.sampler.tick.AbstractTickReporter;
import me.lucko.spark.common.sampler.tick.TickReporter;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ForgeTickReporter
extends AbstractTickReporter
implements TickReporter {
    private final TickEvent.Type type;
    private long start = 0L;

    public ForgeTickReporter(TickEvent.Type type) {
        this.type = type;
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (e.type != this.type) {
            return;
        }
        switch (e.phase) {
            case START: {
                this.start = System.nanoTime();
                break;
            }
            case END: {
                if (this.start == 0L) {
                    return;
                }
                double duration = (double)(System.nanoTime() - this.start) / 1000000.0;
                this.onTick(duration);
                break;
            }
            default: {
                throw new AssertionError(e.phase);
            }
        }
    }

    @Override
    public void start() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void close() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

