/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncStackTraceElement;
import me.lucko.spark.common.sampler.async.ProfileSegment;
import me.lucko.spark.common.sampler.async.jfr.ClassRef;
import me.lucko.spark.common.sampler.async.jfr.JfrReader;
import me.lucko.spark.common.sampler.async.jfr.MethodRef;
import me.lucko.spark.common.sampler.async.jfr.Sample;
import me.lucko.spark.common.sampler.async.jfr.StackTrace;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;
import me.lucko.spark.proto.SparkProtos;

public class AsyncSampler
implements Sampler {
    private final AsyncProfiler profiler = AsyncProfilerAccess.INSTANCE.getProfiler();
    private final ThreadDumper threadDumper;
    private final AsyncDataAggregator dataAggregator;
    private boolean outputComplete = false;
    private Path outputFile;
    private final int interval;
    private long startTime = -1L;

    public AsyncSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper) {
        this.threadDumper = threadDumper;
        this.dataAggregator = new AsyncDataAggregator(threadGrouper);
        this.interval = interval;
    }

    @Override
    public long getStartTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Not yet started");
        }
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return -1L;
    }

    @Override
    public CompletableFuture<? extends Sampler> getFuture() {
        return new CompletableFuture();
    }

    private String execute(String command) {
        try {
            return this.profiler.execute(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception whilst executing profiler command", e);
        }
    }

    @Override
    public void start() {
        String resp;
        this.startTime = System.currentTimeMillis();
        try {
            this.outputFile = Files.createTempFile("spark-profile-", ".jfr.tmp", new FileAttribute[0]);
            this.outputFile.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temporary output file", e);
        }
        String command = "start,event=cpu,interval=" + this.interval + "us,threads,jfr,file=" + this.outputFile.toString();
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            command = command + ",filter";
        }
        if (!(resp = this.execute(command).trim()).equalsIgnoreCase("profiling started")) {
            throw new RuntimeException("Unexpected response: " + resp);
        }
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
            for (Thread thread : threadDumper.getThreads()) {
                this.profiler.addThread(thread);
            }
        }
    }

    @Override
    public void stop() {
        this.profiler.stop();
    }

    @Override
    public SparkProtos.SamplerData toProto(PlatformInfo platformInfo, CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder, String comment, MergeMode mergeMode) {
        SparkProtos.SamplerMetadata.Builder metadata = SparkProtos.SamplerMetadata.newBuilder().setPlatform(platformInfo.toData().toProto()).setUser(creator.toData().toProto()).setStartTime(this.startTime).setInterval(this.interval).setThreadDumper(this.threadDumper.getMetadata()).setDataAggregator(this.dataAggregator.getMetadata());
        if (comment != null) {
            metadata.setComment(comment);
        }
        SparkProtos.SamplerData.Builder proto = SparkProtos.SamplerData.newBuilder();
        proto.setMetadata((SparkProtos.SamplerMetadata)metadata.build());
        this.aggregateOutput();
        ArrayList<Map.Entry<String, ThreadNode>> data = new ArrayList<Map.Entry<String, ThreadNode>>(this.dataAggregator.getData().entrySet());
        data.sort(outputOrder);
        for (Map.Entry entry : data) {
            proto.addThreads(((ThreadNode)entry.getValue()).toProto(mergeMode));
        }
        return (SparkProtos.SamplerData)proto.build();
    }

    private void aggregateOutput() {
        Predicate<String> threadFilter;
        if (this.outputComplete) {
            return;
        }
        this.outputComplete = true;
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
            threadFilter = n -> threadDumper.getThreadNames().contains(n.toLowerCase());
        } else {
            threadFilter = n -> true;
        }
        try (JfrReader reader = new JfrReader(this.outputFile);){
            this.readSegments(reader, threadFilter);
        }
        catch (IOException e) {
            throw new RuntimeException("Read error", e);
        }
        try {
            Files.deleteIfExists(this.outputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSegments(JfrReader reader, Predicate<String> threadFilter) {
        List<Sample> samples = reader.samples;
        for (int i = 0; i < samples.size(); ++i) {
            Sample sample = samples.get(i);
            long duration = i == 0 ? (long)this.interval : TimeUnit.NANOSECONDS.toMicros(sample.time - samples.get((int)(i - 1)).time);
            String threadName = reader.threads.get(sample.tid);
            if (!threadFilter.test(threadName)) continue;
            ProfileSegment segment = AsyncSampler.parseSegment(reader, sample, threadName, duration);
            this.dataAggregator.insertData(segment);
        }
    }

    private static ProfileSegment parseSegment(JfrReader reader, Sample sample, String threadName, long duration) {
        StackTrace stackTrace = reader.stackTraces.get(sample.stackTraceId);
        int len = stackTrace.methods.length;
        AsyncStackTraceElement[] stack = new AsyncStackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            stack[i] = AsyncSampler.parseStackFrame(reader, stackTrace.methods[i]);
        }
        return new ProfileSegment(sample.tid, threadName, stack, duration);
    }

    private static AsyncStackTraceElement parseStackFrame(JfrReader reader, long methodId) {
        AsyncStackTraceElement result = reader.stackFrames.get(methodId);
        if (result != null) {
            return result;
        }
        MethodRef methodRef = reader.methods.get(methodId);
        ClassRef classRef = reader.classes.get(methodRef.cls);
        byte[] className = reader.symbols.get(classRef.name);
        byte[] methodName = reader.symbols.get(methodRef.name);
        if (className == null || className.length == 0) {
            result = new AsyncStackTraceElement("native", new String(methodName, StandardCharsets.UTF_8), null);
        } else {
            byte[] methodDesc = reader.symbols.get(methodRef.sig);
            result = new AsyncStackTraceElement(new String(className, StandardCharsets.UTF_8).replace('/', '.'), new String(methodName, StandardCharsets.UTF_8), new String(methodDesc, StandardCharsets.UTF_8));
        }
        reader.stackFrames.put(methodId, result);
        return result;
    }
}

