/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;

public final class AsyncProfilerAccess {
    public static final AsyncProfilerAccess INSTANCE = new AsyncProfilerAccess();
    private static final String SUPPORTED_OS = "linux";
    private static final String SUPPORTED_ARCH = "amd64";
    private final AsyncProfiler profiler;
    private final Exception setupException;

    private static AsyncProfiler load() throws Exception {
        String os = System.getProperty("os.name");
        if (!SUPPORTED_OS.equalsIgnoreCase(os)) {
            throw new UnsupportedOperationException("Only supported on Linux x86_64, your OS: " + os);
        }
        String arch = System.getProperty("os.arch");
        if (!SUPPORTED_ARCH.equalsIgnoreCase(arch)) {
            throw new UnsupportedOperationException("Only supported on Linux x86_64, your arch: " + os);
        }
        URL profilerResource = AsyncProfilerAccess.class.getClassLoader().getResource("libasyncProfiler.so");
        if (profilerResource == null) {
            throw new IllegalStateException("Could not find libasyncProfiler.so in spark jar file");
        }
        Path extractPath = Files.createTempFile("spark-", "-libasyncProfiler.so.tmp", new FileAttribute[0]);
        extractPath.toFile().deleteOnExit();
        try (InputStream in = profilerResource.openStream();){
            Files.copy(in, extractPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return AsyncProfiler.getInstance(extractPath.toAbsolutePath().toString());
    }

    private AsyncProfilerAccess() {
        AsyncProfiler profiler;
        Exception setupException = null;
        try {
            profiler = AsyncProfilerAccess.load();
            AsyncProfilerAccess.ensureCpuEventSupported(profiler);
        }
        catch (Exception e) {
            profiler = null;
            setupException = e;
        }
        this.profiler = profiler;
        this.setupException = setupException;
    }

    private static void ensureCpuEventSupported(AsyncProfiler profiler) throws Exception {
        String resp = profiler.execute("check,event=cpu").trim();
        if (!resp.equalsIgnoreCase("ok")) {
            throw new UnsupportedOperationException("CPU event is not supported");
        }
    }

    public AsyncProfiler getProfiler() {
        if (this.profiler == null) {
            throw new UnsupportedOperationException("async-profiler not supported", this.setupException);
        }
        return this.profiler;
    }

    public boolean isSupported() {
        if (this.setupException != null) {
            System.out.println("[spark] async-profiler engine is not supported on your system: " + this.setupException.getMessage());
            System.out.println("[spark] Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler");
        }
        return this.profiler != null;
    }
}

