/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.morelibs.api;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHelper {
    public static int MAX_ID = 4096;
    public static byte[] rotateType = new byte[MAX_ID];
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};

    public static boolean isEqual(Block blockA, Block blockB) {
        if (blockA == blockB) {
            return true;
        }
        if (blockA == null | blockB == null) {
            return false;
        }
        return blockA.equals(blockB) || blockA.func_149667_c(blockB);
    }

    public static boolean canRotate(Block block) {
        int id = BlockHelper.getId(block);
        return id < MAX_ID && rotateType[id] != 0;
    }

    public static IBlockState rotateVanillaBlock(World world, IBlockState state, BlockPos pos) {
        int bId = BlockHelper.getId(state.func_177230_c());
        int bMeta = state.func_177230_c().func_176201_c(state);
        Block block = state.func_177230_c();
        switch (rotateType[bId]) {
            case 1: {
                return block.func_176203_a(++bMeta % 8);
            }
            case 2: {
                return block.func_176203_a((bMeta + 8) % 16);
            }
            case 3: {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos offsetPos = pos.func_177972_a(facing);
                    if (!BlockHelper.isEqual(world.func_180495_p(offsetPos).func_177230_c(), state.func_177230_c())) continue;
                    world.func_180501_a(offsetPos, state.func_177230_c().func_176203_a((int)SIDE_OPPOSITE[bMeta]), 1);
                    return block.func_176203_a((int)SIDE_OPPOSITE[bMeta]);
                }
                return block.func_176203_a((int)SIDE_LEFT[bMeta]);
            }
        }
        return block.func_176203_a(bMeta);
    }

    private static int getId(Block block) {
        return Block.func_149682_b((Block)block);
    }

    public static boolean startWith(Block block, String name) {
        return block.getRegistryName().toString().startsWith(name);
    }

    static {
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150333_U)] = 2;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150376_bx)] = 2;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_180389_cP)] = 2;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_185771_cX)] = 2;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150447_bR)] = 3;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150486_ae)] = 3;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150476_ad)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150446_ar)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150389_bf)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150390_bg)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150387_bl)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150372_bz)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150485_bF)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150487_bG)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150481_bH)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_150370_cb)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_180396_cN)] = 1;
        BlockHelper.rotateType[BlockHelper.getId((Block)Blocks.field_185769_cV)] = 1;
    }

    public static final class RotationType {
        public static final int STAIRS = 1;
        public static final int SLAB = 2;
        public static final int CHEST = 3;

        private RotationType() {
        }
    }
}

