/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StringHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;

@ZenClass(value="mods.botania.Brew")
@ModOnly(value="botania")
@ZenRegister
public class Brew {
    public static final String name = "Botania Brew";

    @ZenMethod
    public static void addRecipe(IIngredient[] inputItems, String brewName) {
        if (inputItems == null || inputItems.length == 0 || brewName == null || brewName.length() == 0) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (!BotaniaAPI.brewMap.containsKey(brewName)) {
            LogHelper.logError((String)String.format("Unknown brew name \"%s\" for %s recipe.", brewName, name));
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new RecipeBrew((vazkii.botania.api.brew.Brew)BotaniaAPI.brewMap.get(brewName), InputHelper.toObjects((IIngredient[])inputItems))));
    }

    @ZenMethod
    public static void removeRecipe(String brewName) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(brewName));
    }

    public static class Remove
    extends BaseListRemoval<RecipeBrew> {
        final String brewName;

        protected Remove(String brewName) {
            super(Brew.name, BotaniaAPI.brewRecipes);
            this.brewName = brewName;
        }

        protected String getRecipeInfo(RecipeBrew recipe) {
            return recipe.getBrew().getKey();
        }

        public void apply() {
            LinkedList<RecipeBrew> recipes = new LinkedList<RecipeBrew>();
            Matcher matcher = Pattern.compile(StringHelper.wildcardToRegex((String)this.brewName)).matcher("");
            for (RecipeBrew recipe : BotaniaAPI.brewRecipes) {
                matcher.reset(recipe.getBrew().getKey());
                if (!matcher.matches()) continue;
                recipes.add(recipe);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s. Command ignored!", this.name, this.brewName));
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        public String describe() {
            return "Attempting to remove brewing recipe for " + this.brewName;
        }
    }

    private static class Add
    extends BaseListAddition<RecipeBrew> {
        protected Add(RecipeBrew recipe) {
            super(Brew.name, BotaniaAPI.brewRecipes, Collections.singletonList(recipe));
        }

        protected String getRecipeInfo(RecipeBrew recipe) {
            return recipe.getBrew().getKey();
        }
    }
}

