/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class WireCombiningHandler {
    private static final OrePrefix[] WIRE_DOUBLING_ORDER = new OrePrefix[]{OrePrefix.wireGtSingle, OrePrefix.wireGtDouble, OrePrefix.wireGtQuadruple, OrePrefix.wireGtOctal, OrePrefix.wireGtHex};
    private static final Map<OrePrefix, OrePrefix> cableToWireMap = ImmutableMap.of((Object)OrePrefix.cableGtSingle, (Object)OrePrefix.wireGtSingle, (Object)OrePrefix.cableGtDouble, (Object)OrePrefix.wireGtDouble, (Object)OrePrefix.cableGtQuadruple, (Object)OrePrefix.wireGtQuadruple, (Object)OrePrefix.cableGtOctal, (Object)OrePrefix.wireGtOctal, (Object)OrePrefix.cableGtHex, (Object)OrePrefix.wireGtHex);

    public static void register() {
        OrePrefix.wireGtSingle.addProcessingHandler(PropertyKey.WIRE, WireCombiningHandler::processWireCompression);
        for (OrePrefix wirePrefix : WIRE_DOUBLING_ORDER) {
            wirePrefix.addProcessingHandler(PropertyKey.WIRE, WireCombiningHandler::generateWireCombiningRecipe);
        }
        for (OrePrefix cablePrefix : cableToWireMap.keySet()) {
            cablePrefix.addProcessingHandler(PropertyKey.WIRE, WireCombiningHandler::processCableStripping);
        }
    }

    private static void generateWireCombiningRecipe(OrePrefix wirePrefix, Material material, WireProperties property) {
        int wireIndex = ArrayUtils.indexOf((Object[])WIRE_DOUBLING_ORDER, (Object)wirePrefix);
        if (wireIndex < WIRE_DOUBLING_ORDER.length - 1) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_doubling", material, wirePrefix), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex + 1], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex > 0) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_splitting", material, wirePrefix), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex - 1], material, 2), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex < 3) {
            ModHandler.addShapelessRecipe(String.format("%s_wire_%s_quadrupling", material, wirePrefix), OreDictUnifier.get(WIRE_DOUBLING_ORDER[wireIndex + 2], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
    }

    private static void processWireCompression(OrePrefix prefix, Material material, WireProperties property) {
        for (int startTier = 0; startTier < 4; ++startTier) {
            for (int i = 1; i < 5 - startTier; ++i) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(OreDictUnifier.get(WIRE_DOUBLING_ORDER[startTier], material, 1 << i))).notConsumable(new IntCircuitIngredient((int)Math.pow(2.0, i)))).outputs(OreDictUnifier.get(WIRE_DOUBLING_ORDER[startTier + i], material, 1))).buildAndRegister();
            }
        }
        for (int i = 1; i < 5; ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(OreDictUnifier.get(WIRE_DOUBLING_ORDER[i], material, 1))).notConsumable(new IntCircuitIngredient(1))).outputs(OreDictUnifier.get(WIRE_DOUBLING_ORDER[0], material, (int)Math.pow(2.0, i)))).buildAndRegister();
        }
    }

    private static void processCableStripping(OrePrefix prefix, Material material, WireProperties property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(prefix, material)).output(cableToWireMap.get(prefix), material)).output(OrePrefix.plate, Materials.Rubber, (int)(prefix.secondaryMaterials.get((int)0).amount / 3628800L))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
    }
}

