/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core;

import crafttweaker.CraftTweakerAPI;
import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.SimpleCapabilityManager;
import gregtech.api.cover.CoverBehaviorUIFactory;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.fluids.MetaFluids;
import gregtech.api.gui.UIFactory;
import gregtech.api.items.gui.PlayerInventoryUIFactory;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.modules.GregTechModule;
import gregtech.api.modules.IGregTechModule;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.CapesRegistry;
import gregtech.api.util.NBTUtil;
import gregtech.api.util.VirtualTankRegistry;
import gregtech.api.util.input.KeyBind;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinSaveData;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.common.CommonProxy;
import gregtech.common.ConfigHolder;
import gregtech.common.MetaEntities;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.command.CommandHand;
import gregtech.common.command.CommandRecipeCheck;
import gregtech.common.command.CommandShaders;
import gregtech.common.command.worldgen.CommandWorldgen;
import gregtech.common.covers.CoverBehaviors;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.worldgen.LootTableHelper;
import gregtech.core.advancement.AdvancementTriggers;
import gregtech.core.advancement.internal.AdvancementManager;
import gregtech.core.command.internal.CommandManager;
import gregtech.core.network.internal.NetworkHandler;
import gregtech.core.network.packets.PacketBlockParticle;
import gregtech.core.network.packets.PacketClipboard;
import gregtech.core.network.packets.PacketClipboardNBTUpdate;
import gregtech.core.network.packets.PacketClipboardUIWidgetUpdate;
import gregtech.core.network.packets.PacketFluidVeinList;
import gregtech.core.network.packets.PacketKeysPressed;
import gregtech.core.network.packets.PacketNotifyCapeChange;
import gregtech.core.network.packets.PacketPluginSynced;
import gregtech.core.network.packets.PacketRecoverMTE;
import gregtech.core.network.packets.PacketReloadShaders;
import gregtech.core.network.packets.PacketUIClientAction;
import gregtech.core.network.packets.PacketUIOpen;
import gregtech.core.network.packets.PacketUIWidgetUpdate;
import gregtech.core.sound.GTSoundEvents;
import gregtech.core.sound.internal.SoundManager;
import gregtech.integration.GroovyScriptCompat;
import gregtech.integration.theoneprobe.TheOneProbeCompatibility;
import gregtech.loaders.dungeon.DungeonLootLoader;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@GregTechModule(moduleID="core", containerID="gregtech", name="GregTech Core", descriptionKey="gregtech.modules.core.description", coreModule=true)
public class CoreModule
implements IGregTechModule {
    public static final Logger logger = LogManager.getLogger((String)"GregTech Core");
    @SidedProxy(modId="gregtech", clientSide="gregtech.client.ClientProxy", serverSide="gregtech.common.CommonProxy")
    public static CommonProxy proxy;

    public CoreModule() {
        GregTechAPI.networkHandler = NetworkHandler.getInstance();
    }

    @Override
    @Nonnull
    public Logger getLogger() {
        return logger;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        GregTechAPI.advancementManager = AdvancementManager.getInstance();
        AdvancementTriggers.register();
        GregTechAPI.soundManager = SoundManager.getInstance();
        GTSoundEvents.register();
        GroovyScriptCompat.init();
        GregTechAPI.UI_FACTORY_REGISTRY.unfreeze();
        logger.info("Registering GTCEu UI Factories");
        MetaTileEntityUIFactory.INSTANCE.init();
        PlayerInventoryUIFactory.INSTANCE.init();
        CoverBehaviorUIFactory.INSTANCE.init();
        logger.info("Registering addon UI Factories");
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<UIFactory>(GregTechAPI.UI_FACTORY_REGISTRY, UIFactory.class));
        GregTechAPI.UI_FACTORY_REGISTRY.freeze();
        SimpleCapabilityManager.init();
        GregTechAPI.MATERIAL_REGISTRY.unfreeze();
        logger.info("Registering GTCEu Materials");
        Materials.register();
        logger.info("Registering addon Materials");
        MinecraftForge.EVENT_BUS.post((Event)new GregTechAPI.MaterialEvent());
        if (Loader.isModLoaded((String)"crafttweaker")) {
            logger.info("Running early CraftTweaker initialization scripts...");
            this.runEarlyCraftTweakerScripts();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        GregTechAPI.MATERIAL_REGISTRY.closeRegistry();
        MinecraftForge.EVENT_BUS.post((Event)new GregTechAPI.PostMaterialEvent());
        GregTechAPI.MATERIAL_REGISTRY.freeze();
        OreDictUnifier.init();
        NBTUtil.registerSerializers();
        MetaBlocks.init();
        MetaItems.init();
        ToolItems.init();
        MetaFluids.init();
        GregTechAPI.MTE_REGISTRY.unfreeze();
        logger.info("Registering GTCEu Meta Tile Entities");
        MetaTileEntities.init();
        MetaEntities.init();
        for (BlockWireCoil.CoilType type : BlockWireCoil.CoilType.values()) {
            GregTechAPI.HEATING_COILS.put((Object)MetaBlocks.WIRE_COIL.getState(type), (Object)type);
        }
        proxy.onPreLoad();
        KeyBind.init();
    }

    @Override
    public void registerPackets() {
        GregTechAPI.networkHandler.registerPacket(PacketUIOpen.class);
        GregTechAPI.networkHandler.registerPacket(PacketUIWidgetUpdate.class);
        GregTechAPI.networkHandler.registerPacket(PacketUIClientAction.class);
        GregTechAPI.networkHandler.registerPacket(PacketBlockParticle.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboard.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboardUIWidgetUpdate.class);
        GregTechAPI.networkHandler.registerPacket(PacketPluginSynced.class);
        GregTechAPI.networkHandler.registerPacket(PacketRecoverMTE.class);
        GregTechAPI.networkHandler.registerPacket(PacketKeysPressed.class);
        GregTechAPI.networkHandler.registerPacket(PacketFluidVeinList.class);
        GregTechAPI.networkHandler.registerPacket(PacketNotifyCapeChange.class);
        GregTechAPI.networkHandler.registerPacket(PacketReloadShaders.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboardNBTUpdate.class);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        GregTechAPI.MTE_REGISTRY.freeze();
        proxy.onLoad();
        if (RecipeMap.isFoundInvalidRecipe()) {
            logger.fatal("Seems like invalid recipe was found.");
            if (!ConfigHolder.misc.ignoreErrorOrInvalidRecipes || !FMLForgePlugin.RUNTIME_DEOBF) {
                logger.fatal("Loading cannot continue. Either fix or report invalid recipes, or enable ignoreErrorOrInvalidRecipes in the config as a temporary solution");
                throw new LoaderException("Found at least one invalid recipe. Please read the log above for more details.");
            }
            logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            logger.fatal("Ignoring invalid recipes and continuing loading");
            logger.fatal("Some things may lack recipes or have invalid ones, proceed at your own risk");
            logger.fatal("Report to GTCEu GitHub to get more help and fix the problem");
            logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            logger.info("TheOneProbe found. Enabling integration...");
            TheOneProbeCompatibility.registerCompatibility();
        }
        WorldGenRegistry.INSTANCE.initializeRegistry();
        LootTableHelper.initialize();
        FilterTypeRegistry.init();
        GregTechAPI.COVER_REGISTRY.unfreeze();
        CoverBehaviors.init();
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<CoverDefinition>(GregTechAPI.COVER_REGISTRY, CoverDefinition.class));
        GregTechAPI.COVER_REGISTRY.freeze();
        DungeonLootLoader.init();
    }

    @Optional.Method(modid="crafttweaker")
    private void runEarlyCraftTweakerScripts() {
        CraftTweakerAPI.tweaker.loadScript(false, "gregtech");
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        proxy.onPostLoad();
        BedrockFluidVeinHandler.recalculateChances(true);
        for (Map.Entry entry : GregTechAPI.HEATING_COILS.entrySet()) {
            IHeatingCoilBlockStats value = (IHeatingCoilBlockStats)entry.getValue();
            if (value == null) continue;
            String name = ((IBlockState)entry.getKey()).func_177230_c().func_149739_a();
            if (!name.endsWith(".name")) {
                name = String.format("%s.name", name);
            }
            TemperatureProperty.registerCoilType(value.getCoilTemperature(), value.getMaterial(), name);
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.onLoadComplete(event);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        CommandManager commandManager = CommandManager.getInstance();
        GregTechAPI.commandManager = commandManager;
        commandManager.registerServerCommand(event);
        GregTechAPI.commandManager.addCommand((ICommand)new CommandWorldgen());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandHand());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandRecipeCheck());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandShaders());
        CapesRegistry.load();
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            if (!world.field_72995_K) {
                BedrockFluidVeinSaveData saveData = (BedrockFluidVeinSaveData)world.func_72943_a(BedrockFluidVeinSaveData.class, "gregtech.bedrockFluidVeinData");
                if (saveData == null) {
                    saveData = new BedrockFluidVeinSaveData("gregtech.bedrockFluidVeinData");
                    world.func_72823_a("gregtech.bedrockFluidVeinData", (WorldSavedData)saveData);
                }
                BedrockFluidVeinSaveData.setInstance(saveData);
            }
        }
    }

    @Override
    public void serverStopped(FMLServerStoppedEvent event) {
        VirtualTankRegistry.clearMaps();
        CapesRegistry.clearMaps();
    }
}

