/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuideWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.BooleanConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ColorConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.NumberConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.TextListConfigurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class TextBoxWidget
extends GuideWidget {
    public static final String NAME = "textbox";
    public List<String> content;
    public int space = 1;
    public int fontSize = 9;
    public int fontColor = -16777216;
    public boolean isShadow = false;
    public boolean isCenter = false;
    private transient List<String> textLines;

    public TextBoxWidget(int x, int y, int width, List<String> content, int space, int fontSize, int fontColor, int fill, int stroke, boolean isCenter, boolean isShadow) {
        super(x, y, width, 0);
        this.content = content;
        this.space = space;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
        this.fill = fill;
        this.stroke = stroke;
        this.isCenter = isCenter;
        this.isShadow = isShadow;
        this.initFixed();
    }

    public TextBoxWidget() {
    }

    @Override
    public String getRegistryName() {
        return NAME;
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = super.getTemplate(isFixed);
        template.addProperty("space", (String)null);
        template.addProperty("fontSize", (String)null);
        template.addProperty("fontColor", (String)null);
        template.addProperty("isCenter", (String)null);
        template.addProperty("isShadow", (String)null);
        template.add("content", new Gson().toJsonTree(Arrays.asList("this is a", "textbox!")));
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        group.addWidget(new TextListConfigurator(group, 200, config, "content").setOnUpdated(needUpdate));
        group.addWidget(new BooleanConfigurator(group, config, "isCenter", false).setOnUpdated(needUpdate));
        group.addWidget(new NumberConfigurator(group, config, "fontSize", 9).setOnUpdated(needUpdate));
        group.addWidget(new BooleanConfigurator(group, config, "isShadow", false).setOnUpdated(needUpdate));
        group.addWidget(new ColorConfigurator(group, config, "fontColor", -16777216).setOnUpdated(needUpdate));
        group.addWidget(new NumberConfigurator(group, config, "space", 1).setOnUpdated(needUpdate));
        super.loadConfigurator(group, config, isFixed, needUpdate);
    }

    @Override
    protected Widget initFixed() {
        this.textLines = new ArrayList<String>();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.space = Math.max(this.space, 0);
        this.fontSize = Math.max(this.fontSize, 1);
        int wrapWidth = this.getSize().width * font.field_78288_b / this.fontSize;
        if (this.content != null) {
            for (String textLine : this.content) {
                this.textLines.addAll(font.func_78271_c(I18n.func_135052_a((String)textLine, (Object[])new Object[0]), wrapWidth));
            }
        }
        this.setSize(new Size(this.getSize().width, this.textLines.size() * (this.fontSize + this.space)));
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        if (!this.textLines.isEmpty()) {
            Position position = this.getPosition();
            Size size = this.getSize();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            float scale = (float)this.fontSize * 1.0f / (float)font.field_78288_b;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)position.x / scale), (float)((float)position.y / scale), (float)0.0f);
            float x = 0.0f;
            float y = 0.0f;
            float ySpace = (float)font.field_78288_b + (float)this.space / scale;
            for (String textLine : this.textLines) {
                if (this.isCenter) {
                    x = ((float)size.width / scale - (float)font.func_78256_a(textLine)) / 2.0f;
                }
                font.func_175065_a(textLine, x, y, this.fontColor, this.isShadow);
                y += ySpace;
            }
            GlStateManager.func_179121_F();
        }
    }
}

