/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import gregtech.common.terminal.app.guide.widget.CardWidget;
import gregtech.common.terminal.app.guide.widget.IGuideWidget;
import gregtech.common.terminal.app.guide.widget.ImageWidget;
import gregtech.common.terminal.app.guide.widget.SlotListWidget;
import gregtech.common.terminal.app.guide.widget.TankListWidget;
import gregtech.common.terminal.app.guide.widget.TextBoxWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GuidePageWidget
extends DraggableScrollableWidgetGroup {
    public static final Map<String, IGuideWidget> REGISTER_WIDGETS = new HashMap<String, IGuideWidget>();
    protected TextBoxWidget title;
    protected List<Widget> stream = new ArrayList<Widget>();
    protected List<Widget> fixed = new ArrayList<Widget>();
    protected Interpolator interpolator;
    private final int margin;

    public GuidePageWidget(int xPosition, int yPosition, int width, int height, int margin) {
        super(xPosition, yPosition, width, height);
        this.margin = margin;
        this.setBackground(new ColorRectTexture(-1)).setDraggable(true).setYScrollBarWidth(4).setYBarStyle(new ColorRectTexture(new Color(142, 142, 142)), new ColorRectTexture(new Color(148, 226, 193)));
        this.setUseScissor(false);
    }

    public int getPageWidth() {
        return this.getSize().width - this.yBarWidth;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setTitle(String config) {
        int x = 5;
        int y = 2;
        int width = this.getSize().width - this.yBarWidth - 10;
        int height = 0;
        if (this.title != null) {
            height = this.title.getSize().height;
            x = this.title.getSelfPosition().x;
            y = this.title.getSelfPosition().y;
            this.removeWidget(this.title);
        }
        this.title = new TextBoxWidget(5, 2, width, Collections.singletonList(config), 0, 15, -1, 0x6FFF0000, -16777216, true, true);
        this.addWidget(this.title);
        this.title.setSelfPosition(new Position(x, y));
        int offset = this.title.getSize().height - height;
        if (offset != 0) {
            for (Widget widget : this.stream) {
                widget.addSelfPosition(0, offset);
            }
        }
    }

    public String getTitle() {
        return this.title == null ? "" : String.join((CharSequence)"\n", this.title.content);
    }

    public String loadJsonConfig(String config) {
        try {
            this.loadJsonConfig(new JsonParser().parse(config).getAsJsonObject());
        }
        catch (Exception e) {
            this.clearAllWidgets();
            return e.getMessage();
        }
        return null;
    }

    public void loadJsonConfig(JsonObject config) {
        this.stream.clear();
        this.fixed.clear();
        this.title = null;
        this.clearAllWidgets();
        int pageWidth = this.getPageWidth();
        int margin = this.getMargin();
        this.setTitle(config.get("title").getAsString());
        if (config.has("stream")) {
            this.stream = new ArrayList<Widget>();
            int y = this.title.getSize().height + 10;
            for (JsonElement element : config.getAsJsonArray("stream")) {
                JsonObject widgetConfig = element.getAsJsonObject();
                Widget widget = REGISTER_WIDGETS.get(widgetConfig.get("type").getAsString()).updateOrCreateStreamWidget(margin, y, pageWidth - 2 * margin, widgetConfig);
                y += widget.getSize().height + 5;
                this.stream.add(widget);
                this.addWidget(widget);
            }
        }
        if (config.has("fixed")) {
            this.fixed = new ArrayList<Widget>();
            for (JsonElement element : config.getAsJsonArray("fixed")) {
                JsonObject widgetConfig = element.getAsJsonObject();
                Widget widget = REGISTER_WIDGETS.get(widgetConfig.get("type").getAsString()).updateOrCreateFixedWidget(widgetConfig.get("x").getAsInt(), widgetConfig.get("y").getAsInt(), widgetConfig.get("width").getAsInt(), widgetConfig.get("height").getAsInt(), widgetConfig);
                this.fixed.add(widget);
                this.addWidget(widget);
            }
        }
    }

    public void onSizeUpdate(Widget widget, Size oldSize) {
        int offset = widget.getSize().height - oldSize.height;
        this.maxHeight = Math.max(this.maxHeight, widget.getSize().height + widget.getSelfPosition().y);
        int index = this.stream.indexOf(widget);
        if (index < 0) {
            return;
        }
        for (int i = this.stream.size() - 1; i > index; --i) {
            Widget nextWidget = this.stream.get(i);
            nextWidget.addSelfPosition(0, offset);
        }
    }

    public void onPositionUpdate(Widget widget, Position oldPosition) {
        if (oldPosition.y + widget.getSize().height == this.maxHeight) {
            this.maxHeight = 0;
            for (Widget widget1 : this.widgets) {
                this.maxHeight = Math.max(this.maxHeight, widget1.getSize().height + widget1.getSelfPosition().y + this.scrollYOffset);
            }
        }
    }

    protected int getStreamBottom() {
        if (this.stream != null && this.stream.size() > 0) {
            Widget widget = this.stream.get(this.stream.size() - 1);
            return widget.getSize().height + widget.getSelfPosition().y + this.scrollYOffset;
        }
        return this.title.getSize().height + 10;
    }

    @Override
    public void updateScreen() {
        if (this.interpolator != null) {
            this.interpolator.func_73660_a();
        }
        super.updateScreen();
    }

    public void jumpToRef(String ref) {
        if (this.interpolator != null && !this.interpolator.isFinish()) {
            return;
        }
        for (Widget widget : this.widgets) {
            if (!(widget instanceof IGuideWidget) || !ref.equals(((IGuideWidget)((Object)widget)).getRef())) continue;
            this.interpolator = new Interpolator(this.scrollYOffset, widget.getSelfPosition().y + this.scrollYOffset, 20, Eases.EaseQuadOut, value -> this.setScrollYOffset(value.intValue()), value -> {
                this.interpolator = null;
            });
            this.interpolator.start();
        }
    }

    @Override
    public void addWidget(Widget widget) {
        super.addWidget(widget);
        if (widget instanceof IGuideWidget) {
            ((IGuideWidget)((Object)widget)).setPage(this);
        }
    }

    static {
        REGISTER_WIDGETS.put("textbox", new TextBoxWidget());
        REGISTER_WIDGETS.put("image", new ImageWidget());
        REGISTER_WIDGETS.put("card", new CardWidget());
        REGISTER_WIDGETS.put("slots", new SlotListWidget());
        REGISTER_WIDGETS.put("tanks", new TankListWidget());
    }
}

