/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.JsonObject;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuideWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.BooleanConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.NumberConfigurator;
import java.util.function.Consumer;

public class CardWidget
extends GuideWidget {
    public static final String NAME = "card";
    public int width;
    public int height;
    public boolean isShadow;

    @Override
    public String getRegistryName() {
        return NAME;
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = super.getTemplate(isFixed);
        template.addProperty("fill", (Number)-3745585);
        template.addProperty("width", (Number)120);
        template.addProperty("height", (Number)60);
        template.addProperty("isShadow", Boolean.valueOf(true));
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        group.addWidget(new BooleanConfigurator(group, config, "isShadow", true).setOnUpdated(needUpdate));
        if (!isFixed) {
            group.addWidget(new NumberConfigurator(group, config, "width").setOnUpdated(needUpdate));
            group.addWidget(new NumberConfigurator(group, config, "height").setOnUpdated(needUpdate));
        }
        super.loadConfigurator(group, config, isFixed, needUpdate);
    }

    @Override
    protected Widget initStream() {
        int pageWidth = this.getSize().width;
        int x = this.getSelfPosition().x;
        int y = this.getSelfPosition().y;
        if (this.page != null) {
            x = this.page.getMargin();
            pageWidth = this.page.getPageWidth() - 2 * x;
        }
        this.setSelfPosition(new Position(x + (pageWidth - this.width) / 2, y));
        return this.initFixed();
    }

    @Override
    protected Widget initFixed() {
        this.setSize(new Size(this.width, this.height));
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.isShadow) {
            int x = this.getPosition().x;
            int y = this.getPosition().y;
            int width = this.getSize().width;
            int height = this.getSize().height;
            CardWidget.drawRectShadow(x, y, width, height, 5);
        }
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }
}

