/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.capeselector.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.CapesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class CapeListWidget
extends DraggableScrollableWidgetGroup {
    private final UUID uuid;
    private List<ResourceLocation> capes;
    private int selectedX;
    private int selectedY = -1;

    public CapeListWidget(int xPosition, int yPosition, int width, int height, UUID uuid) {
        super(xPosition, yPosition, width * 70 + 42, height * 56 + 12);
        this.uuid = uuid;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.capes == null) {
            this.updateCapeCandidates(CapesRegistry.getUnlockedCapes(this.uuid));
            this.writeUpdateInfo(-1, buf -> {
                buf.func_150787_b(this.capes.size());
                this.capes.stream().map(ResourceLocation::toString).forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.capes = new ArrayList<ResourceLocation>();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                this.capes.add(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            }
            this.updateCapeCandidates(this.capes);
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    private void updateCapeCandidates(List<ResourceLocation> capes) {
        this.capes = capes;
        int xPosition = this.getSelfPosition().x;
        int yPosition = this.getSelfPosition().y;
        int width = (this.getSize().width - 42) / 70;
        int rowNumber = 0;
        if (capes == null || capes.isEmpty()) {
            return;
        }
        int i = 0;
        while (true) {
            WidgetGroup row = new WidgetGroup();
            for (int rowPosition = 0; rowPosition < width; ++rowPosition) {
                SizedTextureArea capeImage = new SizedTextureArea(capes.get(i), 0.5, 0.0, 0.21875, 0.6875, 28.0, 44.0);
                int finalRowPosition = rowPosition;
                int finalRowNumber = rowNumber;
                int finalI = i;
                ClickButtonWidget capeButton = new ClickButtonWidget(xPosition + rowPosition * 70, yPosition + rowNumber * 56, 28, 44, "", data -> this.setCape(finalRowPosition, finalRowNumber, (ResourceLocation)capes.get(finalI))).setButtonTexture(capeImage).setShouldClientCallback(true);
                row.addWidget(capeButton);
                if (capes.get(i).equals((Object)CapesRegistry.getPlayerCape(this.uuid))) {
                    this.selectedX = finalRowPosition;
                    this.selectedY = finalRowNumber;
                }
                if (++i != capes.size()) continue;
                this.addWidget(row);
                return;
            }
            this.addWidget(row);
            ++rowNumber;
        }
    }

    private void setCape(int x, int y, ResourceLocation cape) {
        if (this.selectedX == x && this.selectedY == y) {
            this.selectedX = -1;
            cape = null;
        } else {
            this.selectedX = x;
            this.selectedY = y;
        }
        if (!this.isRemote()) {
            CapesRegistry.giveCape(this.uuid, cape);
        }
    }

    public List<ResourceLocation> getCapes() {
        return this.capes;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        if (this.selectedX == -1 || this.selectedY == -1) {
            return;
        }
        Widget button = ((WidgetGroup)this.getContainedWidgets(false).get(this.selectedY)).getContainedWidgets(false).get(this.selectedX);
        CapeListWidget.drawSelectionOverlay(button.toRectangleBox().x - 6, button.toRectangleBox().y - 6, button.toRectangleBox().width + 12, button.toRectangleBox().height + 12);
    }
}

