/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.client.renderer.texture.Textures;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MetaTileEntityWorldAccelerator
extends TieredMetaTileEntity
implements IControllable {
    private static Class<?> cofhTileClass;
    private final long energyPerTick;
    private final int speed;
    private boolean tileMode = false;
    private boolean isActive = false;
    private boolean isPaused = false;
    private int lastTick;
    private Supplier<Iterable<BlockPos.MutableBlockPos>> range;

    private static boolean considerTile(TileEntity tile) {
        if (tile instanceof IGregTechTileEntity || tile instanceof TileEntityPipeBase) {
            return false;
        }
        if (cofhTileClass == null) {
            try {
                cofhTileClass = Class.forName("cofh.thermalexpansion.block.device.TileDeviceBase");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cofhTileClass == null || !cofhTileClass.isInstance(tile);
    }

    public MetaTileEntityWorldAccelerator(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.energyPerTick = GTValues.V[tier] * this.getMaxInputOutputAmperage();
        this.lastTick = 0;
        this.speed = (int)Math.pow(2.0, tier);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityWorldAccelerator(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = EnergyContainerHandler.receiverContainer(this, tierVoltage * 256L, tierVoltage, this.getMaxInputOutputAmperage());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in", (Object[])new Object[]{this.getMaxInputOutputAmperage()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area_tile", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area_random", (Object[])new Object[]{this.getTier() * 2, this.getTier() * 2}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return 8L;
    }

    @Override
    public void update() {
        block13: {
            int currentTick;
            super.update();
            if (this.getWorld().field_72995_K) break block13;
            if (this.isPaused) {
                if (this.isActive) {
                    this.setActive(false);
                }
                return;
            }
            if (this.energyContainer.getEnergyStored() < this.energyPerTick) {
                if (this.isActive) {
                    this.setActive(false);
                }
                return;
            }
            if (!this.isActive) {
                this.setActive(true);
            }
            if ((currentTick = FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af()) != this.lastTick) {
                World world = this.getWorld();
                BlockPos currentPos = this.getPos();
                this.lastTick = currentTick;
                if (this.isTEMode()) {
                    this.energyContainer.removeEnergy(this.energyPerTick);
                    for (EnumFacing neighbourFace : EnumFacing.field_82609_l) {
                        TileEntity neighbourTile = world.func_175625_s(currentPos.func_177972_a(neighbourFace));
                        if (!(neighbourTile instanceof ITickable) || neighbourTile.func_145837_r() || !MetaTileEntityWorldAccelerator.considerTile(neighbourTile)) continue;
                        ITickable neighbourTickTile = (ITickable)neighbourTile;
                        for (int i = 0; i < this.speed; ++i) {
                            neighbourTickTile.func_73660_a();
                        }
                    }
                } else {
                    this.energyContainer.removeEnergy(this.energyPerTick / 2L);
                    if (this.range == null) {
                        int area = this.getTier() * 2;
                        this.range = () -> BlockPos.func_177975_b((BlockPos)currentPos.func_177982_a(-area, -area, -area), (BlockPos)currentPos.func_177982_a(area, area, area));
                    }
                    for (BlockPos.MutableBlockPos pos : this.range.get()) {
                        if (pos.func_177956_o() > 256 || pos.func_177956_o() < 0 || !world.func_175667_e((BlockPos)pos)) continue;
                        for (int i = 0; i < this.speed; ++i) {
                            IBlockState state;
                            Block block;
                            if (GTValues.RNG.nextInt(100) >= this.getTier() || !(block = (state = world.func_180495_p((BlockPos)pos)).func_177230_c()).func_149653_t()) continue;
                            block.func_180645_a(world, pos.func_185334_h(), state, world.field_73012_v);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.isTEMode()) {
            Textures.WORLD_ACCELERATOR_TE_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive, this.isWorkingEnabled());
        } else {
            Textures.WORLD_ACCELERATOR_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive, this.isWorkingEnabled());
        }
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            if (this.isTEMode()) {
                this.setTEMode(false);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.world_accelerator.mode_entity", new Object[0]), false);
            } else {
                this.setTEMode(true);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.world_accelerator.mode_tile", new Object[0]), false);
            }
        }
        return true;
    }

    public void setTEMode(boolean inverted) {
        this.tileMode = inverted;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(500, b -> b.writeBoolean(this.tileMode));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    public boolean isTEMode() {
        return this.tileMode;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("TileMode", this.tileMode);
        data.func_74757_a("isPaused", this.isPaused);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tileMode = data.func_74767_n("TileMode");
        this.isPaused = data.func_74767_n("isPaused");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.tileMode);
        buf.writeBoolean(this.isPaused);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.tileMode = buf.readBoolean();
        this.isPaused = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
        if (dataId == 500) {
            this.tileMode = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    protected void setActive(boolean active) {
        this.isActive = active;
        this.markDirty();
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(100, buf -> buf.writeBoolean(active));
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return !this.isPaused;
    }

    @Override
    public void setWorkingEnabled(boolean b) {
        this.isPaused = !b;
        this.notifyBlockUpdate();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }
}

