/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.PipelineUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MetaTileEntityTransformer
extends TieredMetaTileEntity {
    private boolean isTransformUp;

    public MetaTileEntityTransformer(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityTransformer(this.metaTileEntityId, this.getTier());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Inverted", this.isTransformUp);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isTransformUp = data.func_74767_n("Inverted");
        this.reinitializeEnergyContainer();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isTransformUp);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isTransformUp = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 500) {
            this.isTransformUp = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public boolean isInverted() {
        return this.isTransformUp;
    }

    public void setTransformUp(boolean inverted) {
        this.isTransformUp = inverted;
        if (!this.getWorld().field_72995_K) {
            this.reinitializeEnergyContainer();
            this.writeCustomData(500, b -> b.writeBoolean(this.isTransformUp));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        if (this.isTransformUp) {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 8L, tierVoltage, 4L, tierVoltage * 4L, 1L);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s != this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 8L, tierVoltage * 4L, 1L, tierVoltage, 4L);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s == this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s != this.getFrontFacing());
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        SimpleOverlayRenderer otherFaceTexture = this.isTransformUp ? Textures.ENERGY_IN : Textures.ENERGY_OUT;
        SimpleOverlayRenderer frontFaceTexture = this.isTransformUp ? Textures.ENERGY_OUT_MULTI : Textures.ENERGY_IN_MULTI;
        frontFaceTexture.renderSided(this.frontFacing, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier() + 1]));
        Arrays.stream(EnumFacing.values()).filter(f -> f != this.frontFacing).forEach(f -> otherFaceTexture.renderSided((EnumFacing)f, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()])));
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public boolean onSoftMalletClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            this.scheduleRenderUpdate();
            return true;
        }
        if (this.isTransformUp) {
            this.setTransformUp(false);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_down", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        } else {
            this.setTransformUp(true);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_up", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        }
        return true;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String lowerTierName = GTValues.VNF[this.getTier()];
        String higherTierName = GTValues.VNF[this.getTier() + 1];
        long lowerVoltage = this.energyContainer.getOutputVoltage();
        long higherVoltage = this.energyContainer.getInputVoltage();
        long lowerAmperage = this.energyContainer.getInputAmperage();
        long higherAmperage = this.energyContainer.getOutputAmperage();
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_tool_usage", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_down", (Object[])new Object[]{lowerAmperage, higherVoltage, higherTierName, higherAmperage, lowerVoltage, lowerTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_up", (Object[])new Object[]{higherAmperage, lowerVoltage, lowerTierName, lowerAmperage, higherVoltage, higherTierName}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.toggle_mode", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

