/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.metatileentities.electric.MetaTileEntityTransformer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MetaTileEntityAdjustableTransformer
extends MetaTileEntityTransformer {
    private static final int[] hiAmpsRange = new int[]{1, 2, 4, 16};
    private static final int[] loAmpsRange = new int[]{4, 8, 16, 64};
    private int ampIndex = 2;

    public MetaTileEntityAdjustableTransformer(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.reinitializeEnergyContainer();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityAdjustableTransformer(this.metaTileEntityId, this.getTier());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("ampIndex", this.ampIndex);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.ampIndex = data.func_74762_e("ampIndex");
        this.reinitializeEnergyContainer();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.ampIndex);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.ampIndex = buf.readInt();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 101) {
            this.ampIndex = buf.readInt();
            this.scheduleRenderUpdate();
        }
    }

    protected void incrementAmpIndex() {
        this.ampIndex = (this.ampIndex + 1) % hiAmpsRange.length;
        if (!this.getWorld().field_72995_K) {
            this.reinitializeEnergyContainer();
            this.writeCustomData(101, b -> b.writeInt(this.ampIndex));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        if (this.isInverted()) {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 128L, tierVoltage, loAmpsRange[this.ampIndex], tierVoltage * 4L, hiAmpsRange[this.ampIndex]);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s != this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 128L, tierVoltage * 4L, hiAmpsRange[this.ampIndex], tierVoltage, loAmpsRange[this.ampIndex]);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s == this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s != this.getFrontFacing());
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        SimpleOverlayRenderer frontFaceTexture;
        SimpleOverlayRenderer otherFaceTexture;
        super.renderMetaTileEntity(renderState, translation, pipeline);
        switch (this.ampIndex) {
            case 1: {
                otherFaceTexture = this.isInverted() ? Textures.ENERGY_IN_MULTI : Textures.ENERGY_OUT_MULTI;
                frontFaceTexture = this.isInverted() ? Textures.ENERGY_IN_HI : Textures.ENERGY_IN_HI;
                break;
            }
            case 2: {
                otherFaceTexture = this.isInverted() ? Textures.ENERGY_IN_HI : Textures.ENERGY_OUT_HI;
                frontFaceTexture = this.isInverted() ? Textures.ENERGY_OUT_ULTRA : Textures.ENERGY_IN_ULTRA;
                break;
            }
            case 3: {
                otherFaceTexture = this.isInverted() ? Textures.ENERGY_IN_ULTRA : Textures.ENERGY_OUT_ULTRA;
                frontFaceTexture = this.isInverted() ? Textures.ENERGY_OUT_ULTRA : Textures.ENERGY_IN_ULTRA;
                break;
            }
            default: {
                otherFaceTexture = this.isInverted() ? Textures.ENERGY_IN : Textures.ENERGY_OUT;
                frontFaceTexture = this.isInverted() ? Textures.ENERGY_OUT_MULTI : Textures.ENERGY_IN_MULTI;
            }
        }
        frontFaceTexture.renderSided(this.frontFacing, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier() + 1]));
        Arrays.stream(EnumFacing.values()).filter(f -> f != this.frontFacing).forEach(f -> otherFaceTexture.renderSided((EnumFacing)f, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()])));
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            this.scheduleRenderUpdate();
            return true;
        }
        this.incrementAmpIndex();
        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer_adjustable.message_adjust", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String lowerTierName = GTValues.VNF[this.getTier()];
        String higherTierName = GTValues.VNF[this.getTier() + 1];
        long lowerVoltage = this.energyContainer.getOutputVoltage();
        long higherVoltage = this.energyContainer.getInputVoltage();
        long lowerAmperage = this.energyContainer.getInputAmperage();
        long higherAmperage = this.energyContainer.getOutputAmperage();
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer_adjustable.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_tool_usage", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer_adjustable.tooltip_tool_usage", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_down", (Object[])new Object[]{lowerAmperage, higherVoltage, higherTierName, higherAmperage, lowerVoltage, lowerTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_up", (Object[])new Object[]{higherAmperage, lowerVoltage, lowerTierName, lowerAmperage, higherVoltage, higherTierName}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.toggle_mode", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
    }
}

