/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemMaxStackSizeProvider;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.RotorProperty;
import gregtech.common.items.behaviors.AbstractMaterialPartBehavior;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class TurbineRotorBehavior
extends AbstractMaterialPartBehavior
implements IItemMaxStackSizeProvider {
    @Override
    public int getPartMaxDurability(ItemStack itemStack) {
        Material material = this.getPartMaterial(itemStack);
        RotorProperty property = material.getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : 800 * (int)Math.pow(property.getDurability(), 0.65);
    }

    public int getRotorEfficiency(ItemStack stack) {
        Material material = this.getPartMaterial(stack);
        RotorProperty property = material.getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(60.0f + property.getSpeed() * 8.0f) / 5 * 5;
    }

    public int getRotorDurabilityPercent(ItemStack itemStack) {
        return 100 - 100 * this.getPartDamage(itemStack) / this.getPartMaxDurability(itemStack);
    }

    public void applyRotorDamage(ItemStack itemStack, int damageApplied) {
        int rotorDurability = this.getPartMaxDurability(itemStack);
        int resultDamage = this.getPartDamage(itemStack) + damageApplied;
        if (resultDamage >= rotorDurability) {
            itemStack.func_190918_g(1);
        } else {
            this.setPartDamage(itemStack, resultDamage);
        }
    }

    public int getRotorPower(ItemStack stack) {
        Material material = this.getPartMaterial(stack);
        RotorProperty property = material.getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(40.0f + property.getDamage() * 30.0f);
    }

    @Override
    public int getMaxStackSize(ItemStack itemStack, int defaultValue) {
        return 1;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> lines) {
        super.addInformation(stack, lines);
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.rotor.efficiency", (Object[])new Object[]{this.getRotorEfficiency(stack)}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.rotor.power", (Object[])new Object[]{this.getRotorPower(stack)}));
    }

    @Nullable
    public static TurbineRotorBehavior getInstanceFor(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof MetaItem)) {
            return null;
        }
        Object valueItem = ((MetaItem)itemStack.func_77973_b()).getItem(itemStack);
        if (valueItem == null) {
            return null;
        }
        IItemDurabilityManager durabilityManager = ((MetaItem.MetaValueItem)valueItem).getDurabilityManager();
        if (!(durabilityManager instanceof TurbineRotorBehavior)) {
            return null;
        }
        return (TurbineRotorBehavior)durabilityManager;
    }
}

