/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource;

import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.itemsource.ItemSource;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class NetworkItemInfo
implements IItemInfo {
    private final ItemStackKey itemStackKey;
    private int totalItemAmount = 0;
    private final Map<ItemSource, Integer> inventories = new TreeMap<ItemSource, Integer>(Comparator.comparingInt(ItemSource::getPriority));

    public NetworkItemInfo(ItemStackKey itemStackKey) {
        this.itemStackKey = itemStackKey;
    }

    @Override
    public int getTotalItemAmount() {
        return this.totalItemAmount;
    }

    @Override
    public ItemStackKey getItemStackKey() {
        return this.itemStackKey;
    }

    void addToSource(ItemSource itemSource, int amount) {
        this.inventories.computeIfPresent(itemSource, (key, value) -> value + amount);
        this.inventories.putIfAbsent(itemSource, amount);
        this.totalItemAmount += amount;
    }

    void removeFromSource(ItemSource itemSource, int amount) {
        this.inventories.computeIfPresent(itemSource, (key, value) -> {
            if (amount >= value) {
                return null;
            }
            return value - amount;
        });
        this.totalItemAmount = Math.max(0, this.totalItemAmount - amount);
        if (this.totalItemAmount == 0) {
            this.inventories.remove(itemSource);
        }
    }
}

