/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.among_us;

import gregtech.api.GTValues;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec2f;

public class FixWiringTaskWidget
extends Widget {
    private static final TextureArea background = TextureArea.fullImage("textures/gui/widget/electricity_wires_baseback.png");
    private static final TextureArea wire = TextureArea.fullImage("textures/gui/widget/electricity_wires.png");
    private static final TextureArea wire_base = TextureArea.fullImage("textures/gui/widget/electricity_wires_base.png");
    private final int[] colors = new int[4];
    private final boolean[] connect = new boolean[4];
    private final int[] init = new int[4];
    private Consumer<Integer> onConnected;
    private Runnable onFinished;
    private BiPredicate<Integer, ItemStack> hoverItemCheck;
    private int dragged = -1;
    private Supplier<Boolean> canInteractPredicate = () -> true;

    public FixWiringTaskWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        for (int i = 0; i < 4; ++i) {
            this.colors[i] = GTValues.RNG.nextInt() & 0xFFFFFF | 0xFF000000;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3));
        Collections.shuffle(list);
        for (int i = 0; i < list.size(); ++i) {
            this.init[i] = (Integer)list.get(i);
        }
    }

    public FixWiringTaskWidget setOnFinished(Runnable onFinished) {
        this.onFinished = onFinished;
        return this;
    }

    public FixWiringTaskWidget setOnConnected(Consumer<Integer> onConnected) {
        this.onConnected = onConnected;
        return this;
    }

    public FixWiringTaskWidget setHoverItemCheck(BiPredicate<Integer, ItemStack> hoverItemCheck) {
        this.hoverItemCheck = hoverItemCheck;
        return this;
    }

    public FixWiringTaskWidget setCanInteractPredicate(Supplier<Boolean> canInteractPredicate) {
        this.canInteractPredicate = canInteractPredicate;
        return this;
    }

    public void setColor(int index, int color) {
        this.colors[index] = color;
    }

    public boolean getConnected(int index) {
        return this.connect[index];
    }

    public int isMouseOverWire(int mouseX, int mouseY, boolean isLeft) {
        if (!this.canInteractPredicate.get().booleanValue()) {
            return -1;
        }
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        float xScale = (float)width / 504.0f;
        float yScale = (float)height / 504.0f;
        for (int i = 0; i < 4; ++i) {
            double y1 = (float)y + yScale * (float)((i + 1) * 104 - 10);
            if (!(isLeft ? FixWiringTaskWidget.isMouseOver(x, (int)(y1 - (double)(yScale * 16.0f)), (int)((double)(xScale * 38.0f) * 1.5), (int)(yScale * 64.0f), mouseX, mouseY) : FixWiringTaskWidget.isMouseOver(x + width - (int)((double)(xScale * 38.0f) * 1.5), (int)(y1 - (double)(yScale * 16.0f)), (int)((double)(xScale * 38.0f) * 1.5), (int)(yScale * 64.0f), mouseX, mouseY))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int color;
        double y1;
        int i;
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        background.draw(x, y, width, height);
        float xScale = (float)width / 504.0f;
        float yScale = (float)height / 504.0f;
        block0: for (i = 0; i < 4; ++i) {
            y1 = (float)y + yScale * (float)((i + 1) * 104 - 10);
            color = this.colors[i];
            if (!this.connect[i]) continue;
            for (int j = 0; j < this.init.length; ++j) {
                if (this.init[j] != i) continue;
                double y2 = (float)y + yScale * (float)((j + 1) * 104 - 10);
                FixWiringTaskWidget.drawLines(Arrays.asList(new Vec2f((float)x + xScale * 25.0f, (float)y1 + yScale * 12.0f), new Vec2f((float)(x + width - (int)(xScale * 25.0f)), (float)y2 + yScale * 12.0f)), color, color, 5.0f);
                continue block0;
            }
        }
        for (i = 0; i < 4; ++i) {
            y1 = (float)y + yScale * (float)((i + 1) * 104 - 10);
            color = this.colors[i];
            if (this.dragged == i) {
                FixWiringTaskWidget.drawLines(Arrays.asList(new Vec2f((float)x + xScale * 25.0f, (float)y1 + yScale * 12.0f), new Vec2f((float)mouseX, (float)mouseY)), color, color, 5.0f);
            }
            wire.drawSubArea(x + (int)(xScale * 25.0f), y1 - (double)(yScale * 5.0f), (int)(xScale * 38.0f), (int)(yScale * 32.0f), 0.0, 0.0, 0.5, 1.0);
            FixWiringTaskWidget.setColor(color);
            wire_base.drawSubArea(x, (int)y1, (int)(xScale * 50.0f), (int)(yScale * 32.0f), 0.0, 0.0, 0.5, 1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            wire.drawSubArea(x + width - (int)(xScale * 63.0f), y1 - (double)(yScale * 5.0f), (int)(xScale * 38.0f), (int)(yScale * 32.0f), 0.5, 0.0, 0.5, 1.0);
            FixWiringTaskWidget.setColor(this.colors[this.init[i]]);
            wire_base.drawSubArea(x + width - (int)(xScale * 50.0f), (int)y1, (int)(xScale * 50.0f), (int)(yScale * 32.0f), 0.5, 0.0, 0.5, 1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        int over = this.isMouseOverWire(mouseX, mouseY, true);
        ItemStack holdStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
        if (over != -1 && !this.connect[over] && (this.hoverItemCheck == null || this.hoverItemCheck.test(over, holdStack))) {
            this.dragged = over;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        int over;
        if (this.dragged != -1 && (over = this.isMouseOverWire(mouseX, mouseY, false)) != -1 && this.init[over] == this.dragged) {
            this.connect[this.dragged] = true;
            this.writeClientAction(5, buffer -> buffer.func_150787_b(this.dragged));
        }
        this.dragged = -1;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 5) {
            int connected = buffer.func_150792_a();
            this.connect[connected] = true;
            if (this.onConnected != null) {
                this.onConnected.accept(connected);
            }
            if (this.connect[0] && this.connect[1] && this.connect[2] && this.connect[3] && this.onFinished != null) {
                this.onFinished.run();
            }
        }
    }
}

