/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.Position;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetARGB
extends WidgetGroup {
    public int color;
    private final int height;

    public WidgetARGB(int x, int y, int height, int initColor, Consumer<Integer> onColorChanged) {
        super(new Position(x, y));
        this.color = initColor;
        this.height = height;
        Predicate<String> validator = data -> {
            if (data.equals("")) {
                return true;
            }
            try {
                int num = Integer.parseInt(data, 16);
                if (num > 255 || num < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        };
        Consumer<PacketBuffer> update = buf -> buf.writeInt(this.color);
        TextFieldWidget[] ARGB = new TextFieldWidget[]{new TextFieldWidget(0, 0, 20, height, true, () -> Integer.toHexString(this.color >> 24 & 0xFF).toUpperCase(), data -> {
            this.color = (data.equals("") ? 0 : Integer.parseInt(data, 16)) << 24 | this.color & 0xFFFFFF;
            onColorChanged.accept(this.color);
            this.writeUpdateInfo(2, update);
        }).setValidator(validator), new TextFieldWidget(22, 0, 20, height, true, () -> Integer.toHexString(this.color >> 16 & 0xFF).toUpperCase(), data -> {
            this.color = (data.equals("") ? 0 : Integer.parseInt(data, 16)) << 16 | this.color & 0xFF00FFFF;
            onColorChanged.accept(this.color);
            this.writeUpdateInfo(2, update);
        }).setValidator(validator), new TextFieldWidget(44, 0, 20, height, true, () -> Integer.toHexString(this.color >> 8 & 0xFF).toUpperCase(), data -> {
            this.color = (data.equals("") ? 0 : Integer.parseInt(data, 16)) << 8 | this.color & 0xFF00FF;
            onColorChanged.accept(this.color);
            this.writeUpdateInfo(2, update);
        }).setValidator(validator), new TextFieldWidget(66, 0, 20, height, true, () -> Integer.toHexString(this.color & 0xFF).toUpperCase(), data -> {
            this.color = (data.equals("") ? 0 : Integer.parseInt(data, 16)) | this.color & 0xFFFFFF00;
            onColorChanged.accept(this.color);
            this.writeUpdateInfo(2, update);
        }).setValidator(validator)};
        this.addWidget(ARGB[0]);
        this.addWidget(ARGB[1]);
        this.addWidget(ARGB[2]);
        this.addWidget(ARGB[3]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.color = buffer.readInt();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Gui.func_73734_a((int)(this.getPosition().x + 88), (int)this.getPosition().y, (int)(this.getPosition().x + 100), (int)(this.getPosition().y + this.height), (int)this.color);
    }
}

