/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.DrawableWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.OreDictFilterTestSlot;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.api.util.OreDictExprFilter;
import gregtech.common.covers.filter.ItemFilter;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenCustomHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class OreDictionaryItemFilter
extends ItemFilter {
    protected String oreDictFilterExpression = "";
    private String testMsg = "";
    private boolean testResult;
    private ItemStack testStack = ItemStack.field_190927_a;
    private final List<OreDictExprFilter.MatchRule> matchRules = new ArrayList<OreDictExprFilter.MatchRule>();
    private static final Hash.Strategy<ItemStack> strategy = ItemStackHashStrategy.builder().compareItem(true).compareDamage(true).build();
    private final Map<ItemStack, Boolean> recentlyChecked = new Object2BooleanOpenCustomHashMap(strategy);

    protected void setOreDictFilterExpression(String oreDictFilterExpression) {
        this.oreDictFilterExpression = oreDictFilterExpression;
        OreDictExprFilter.parseExpression(this.matchRules, oreDictFilterExpression);
        this.recentlyChecked.clear();
        this.markDirty();
        this.updateTestMsg();
    }

    public String getOreDictFilterExpression() {
        return this.oreDictFilterExpression;
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new ImageWidget(12, 0, 20, 20, GuiTextures.INFO_ICON).setTooltip("cover.ore_dictionary_filter.info"));
        widgetGroup.accept(new ImageWidget(10, 25, 156, 14, GuiTextures.DISPLAY));
        widgetGroup.accept(new TextFieldWidget2(14, 29, 152, 12, () -> this.oreDictFilterExpression, this::setOreDictFilterExpression).setAllowedChars(Pattern.compile("[(!]* *[0-9a-zA-Z*]* *\\)*( *[&|^]? *[(!]* *[0-9a-zA-Z*]* *\\)*)*")).setMaxLength(64).setScale(0.75f).setValidator(input -> {
            int i;
            input = input.replaceAll("\\*{2,}", "*");
            input = input.replaceAll("&{2,}", "&");
            input = input.replaceAll("\\|{2,}", "|");
            input = input.replaceAll("!{2,}", "!");
            input = input.replaceAll("\\^{2,}", "^");
            input = input.replaceAll(" {2,}", " ");
            StringBuilder builder = new StringBuilder();
            int unclosed = 0;
            char last = ' ';
            for (i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == ' ') {
                    if (last == 40) continue;
                    builder.append(" ");
                    continue;
                }
                if (c == '(') {
                    ++unclosed;
                } else if (c == ')') {
                    --unclosed;
                    if (last == '&' || last == '|' || last == '^') {
                        int l2;
                        int l = builder.lastIndexOf(" " + last);
                        builder.insert(l == (l2 = builder.lastIndexOf("" + last)) - 1 ? l : l2, ")");
                        continue;
                    }
                    if (i > 0 && builder.charAt(builder.length() - 1) == ' ') {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                } else if ((c == '&' || c == '|' || c == '^') && last == '(') {
                    builder.deleteCharAt(builder.lastIndexOf("("));
                    builder.append(c).append(" (");
                    continue;
                }
                builder.append(c);
                last = c;
            }
            if (unclosed > 0) {
                for (i = 0; i < unclosed; ++i) {
                    builder.append(")");
                }
            } else if (unclosed < 0) {
                unclosed = -unclosed;
                for (i = 0; i < unclosed; ++i) {
                    builder.insert(0, "(");
                }
            }
            input = builder.toString();
            input = input.replaceAll(" {2,}", " ");
            return input;
        }));
        widgetGroup.accept(new DrawableWidget(36, 1, 100, 18).setBackgroundDrawer((mouseX, mouseY, partialTicks, context, widget) -> {
            if (this.testStack.func_190926_b()) {
                return;
            }
            int color = 13719640;
            if (this.testResult) {
                color = 6734433;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)widget.getPosition().x, (float)widget.getPosition().y, (float)0.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            Widget.drawText(I18n.func_135052_a((String)this.testMsg, (Object[])new Object[0]), 22.0f, 6.5f, 0.75f, color, false);
            Widget.drawGradientRect(0, 0, 18, 18, color |= 0x8C000000, color);
            GlStateManager.func_179121_F();
        }));
        widgetGroup.accept(new OreDictFilterTestSlot(36, 1).setListener(stack -> {
            this.testStack = stack;
            this.updateTestMsg();
        }));
    }

    private void updateTestMsg() {
        if (this.testStack.func_190926_b()) {
            this.testMsg = "";
            return;
        }
        this.testResult = this.matchesItemStack(this.testStack);
        this.testMsg = this.testResult ? "cover.ore_dictionary_filter.matches" : "cover.ore_dictionary_filter.matches_not";
    }

    @Override
    public Object matchItemStack(ItemStack itemStack) {
        return this.matchesItemStack(itemStack) ? "wtf is this system?? i can put any non null object here and it i will work??? $arch" : null;
    }

    public boolean matchesItemStack(ItemStack itemStack) {
        Boolean b = this.recentlyChecked.get(itemStack);
        if (b != null) {
            return b;
        }
        if (OreDictExprFilter.matchesOreDict(this.matchRules, itemStack)) {
            this.recentlyChecked.put(itemStack, true);
            return true;
        }
        this.recentlyChecked.put(itemStack, false);
        return false;
    }

    @Override
    public int getSlotTransferLimit(Object matchSlot, int globalTransferLimit) {
        return globalTransferLimit;
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return true;
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 37;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("OreDictionaryFilter", this.oreDictFilterExpression);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.oreDictFilterExpression = tagCompound.func_74779_i("OreDictionaryFilter");
        OreDictExprFilter.parseExpression(this.matchRules, this.oreDictFilterExpression);
    }
}

