/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.facade;

import com.google.common.collect.ImmutableList;
import gregtech.api.util.GTUtility;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;

public class FacadeHelper {
    private static ImmutableList<ItemStack> validFacadeItems = null;

    private static ImmutableList<ItemStack> retrieveValidItemsList() {
        return StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(item -> item instanceof ItemBlock).flatMap(item -> FacadeHelper.getSubItems(item).stream()).filter(FacadeHelper::isValidFacade).collect(GTUtility.toImmutableList());
    }

    public static ImmutableList<ItemStack> getValidFacadeItems() {
        if (validFacadeItems == null) {
            validFacadeItems = FacadeHelper.retrieveValidItemsList();
        }
        return validFacadeItems;
    }

    private static List<ItemStack> getSubItems(Item item) {
        NonNullList list = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, list);
        return list;
    }

    public static boolean isValidFacade(ItemStack itemStack) {
        IBlockState rawBlockState = FacadeHelper.lookupBlockForItemUnsafe(itemStack);
        return rawBlockState != null && !rawBlockState.func_177230_c().hasTileEntity(rawBlockState) && !rawBlockState.func_177230_c().func_149716_u() && rawBlockState.func_185901_i() == EnumBlockRenderType.MODEL && rawBlockState.func_185917_h();
    }

    public static IBlockState lookupBlockForItem(ItemStack itemStack) {
        IBlockState rawBlockState = FacadeHelper.lookupBlockForItemUnsafe(itemStack);
        if (rawBlockState == null) {
            return Blocks.field_150348_b.func_176223_P();
        }
        return rawBlockState;
    }

    private static IBlockState lookupBlockForItemUnsafe(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
        int blockMetadata = itemStack.func_77973_b().getMetadata(itemStack);
        try {
            return block.func_176203_a(blockMetadata);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

